/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Getter;
import ch.njol.skript.data.DefaultChangers;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Slot;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class VarTool
extends SimpleVariable<Slot> {
    private Variable<Player> players;

    static {
        Skript.registerVariable(VarTool.class, Slot.class, "(tool|held item) [of %players%]", "%player%'[s] (tool|held item)");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.players = vars[0];
    }

    protected Slot[] getAll(Event e) {
        return this.players.getArray(e, Slot.class, new Getter<Slot, Player>(){

            @Override
            public Slot get(final Player p) {
                return new Slot((Inventory)p.getInventory(), p.getInventory().getHeldItemSlot()){

                    @Override
                    public void setItem(ItemStack item) {
                        p.setItemInHand(item);
                    }

                    @Override
                    public ItemStack getItem() {
                        return p.getItemInHand();
                    }

                    @Override
                    public String getDebugMessage(Event e) {
                        return "tool of " + p.getName();
                    }
                };
            }
        });
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return DefaultChangers.slotChanger.acceptChange(mode);
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) {
        DefaultChangers.slotChanger.change(e, this, delta, mode);
    }

    @Override
    public Class<Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return "tool of " + this.players.getDebugMessage(e);
        }
        return Skript.getDebugMessage(this.getSingle(e));
    }

    @Override
    public String toString() {
        return "the tool of " + this.players;
    }

    @Override
    public boolean isSingle() {
        return this.players.isSingle();
    }
}

