/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Getter;
import ch.njol.skript.data.DefaultChangers;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Time;
import org.bukkit.World;
import org.bukkit.event.Event;

public class VarTime
extends SimpleVariable<Time> {
    private Variable<World> worlds = null;

    static {
        Skript.registerVariable(VarTime.class, Time.class, "time [(in|of) %worlds%]");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.worlds = vars[0];
    }

    protected Time[] getAll(Event e) {
        return this.worlds.getArray(e, Time.class, new Getter<Time, World>(){

            @Override
            public Time get(World w) {
                return new Time((int)w.getTime());
            }
        });
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return DefaultChangers.timeChanger.acceptChange(mode);
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) {
        DefaultChangers.timeChanger.change(e, this.worlds, delta, mode);
    }

    @Override
    public Class<Time> getReturnType() {
        return Time.class;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return "time in " + this.worlds.getDebugMessage(e);
        }
        return Skript.getDebugMessage(this.getAll(e));
    }

    @Override
    public String toString() {
        return "the time in " + this.worlds;
    }

    @Override
    public boolean isSingle() {
        return this.worlds.isSingle();
    }
}

