/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Converter;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class VarGameMode
extends SimpleVariable<GameMode> {
    private Variable<Player> players;

    static {
        Skript.registerVariable(VarGameMode.class, GameMode.class, "game[ ]mode of %players%", "%players%'[s] game[ ]mode");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.players = vars[0];
    }

    @Override
    public String getDebugMessage(Event e) {
        return "gamemode of " + this.players.getDebugMessage(e);
    }

    protected GameMode[] getAll(Event e) {
        return this.players.getArray(e, GameMode.class, new Converter<Player, GameMode>(){

            @Override
            public GameMode convert(Player p) {
                return p.getGameMode();
            }
        });
    }

    @Override
    public Class<? extends GameMode> getReturnType() {
        return GameMode.class;
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return GameMode.class;
        }
        return null;
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        GameMode m = (GameMode)delta.getSingle(e);
        Player[] playerArray = this.players.getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            p.setGameMode(m);
            ++n2;
        }
    }

    @Override
    public String toString() {
        return "the gamemode of " + this.players;
    }

    @Override
    public boolean isSingle() {
        return this.players.isSingle();
    }
}

