/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Getter;
import ch.njol.skript.data.DefaultChangers;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Slot;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;

public class VarFurnaceSlot
extends SimpleVariable<Slot> {
    private Variable<Block> blocks;
    private int slot;
    private static final String[] slotNames;

    static {
        Skript.registerVariable(VarFurnaceSlot.class, Slot.class, "ore [slot] [of %blocks%]", "%block%'[s] ore [slot]", "fuel [slot] [of %blocks%]", "%block%'[s] fuel [slot]", "result [slot] [of %blocks%]", "%block%'[s] result [slot]");
        slotNames = new String[]{"ore", "fuel", "result"};
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.blocks = vars[0];
        this.slot = matchedPattern / 2;
    }

    protected Slot[] getAll(Event e) {
        return this.blocks.getArray(e, Slot.class, new Getter<Slot, Block>(){

            @Override
            public Slot get(Block b) {
                if (b.getType() != Material.FURNACE) {
                    return null;
                }
                return new Slot((Inventory)((Furnace)b.getState()).getInventory(), VarFurnaceSlot.this.slot);
            }
        });
    }

    @Override
    public Class<? extends Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return String.valueOf(slotNames[this.slot]) + " slot of " + this.blocks.getDebugMessage(e);
        }
        return Skript.getDebugMessage(this.getSingle(e));
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return DefaultChangers.slotChanger.acceptChange(mode);
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) {
        DefaultChangers.slotChanger.change(e, this, delta, mode);
    }

    @Override
    public String toString() {
        return "the " + slotNames[this.slot] + " slot of " + this.blocks;
    }

    @Override
    public boolean isSingle() {
        return this.blocks.isSingle();
    }
}

