/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Getter;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class VarFoodLevel
extends SimpleVariable<Integer> {
    private Variable<Player> players;

    static {
        Skript.registerVariable(VarFoodLevel.class, Integer.class, "food[[ ](level|meter)] [of %player%]", "%player%'[s] food[[ ](level|meter)]");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.players = vars[0];
    }

    @Override
    public String getDebugMessage(Event e) {
        return "food level of " + this.players.getDebugMessage(e);
    }

    protected Integer[] getAll(Event e) {
        return this.players.getArray(e, Integer.class, new Getter<Integer, Player>(){

            @Override
            public Integer get(Player p) {
                return p.getFoodLevel();
            }
        });
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return Integer.class;
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) {
        int s = 0;
        if (mode != Changer.ChangeMode.CLEAR) {
            s = (Integer)delta.getSingle(e);
        }
        switch (mode) {
            case SET: 
            case CLEAR: {
                Player[] playerArray = this.players.getArray(e);
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player player = playerArray[n2];
                    player.setFoodLevel(s);
                    ++n2;
                }
                return;
            }
            case ADD: {
                Player[] playerArray = this.players.getArray(e);
                int n = playerArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Player player = playerArray[n3];
                    player.setFoodLevel(player.getFoodLevel() + s);
                    ++n3;
                }
                return;
            }
            case REMOVE: {
                Player[] playerArray = this.players.getArray(e);
                int n = playerArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Player player = playerArray[n4];
                    player.setFoodLevel(player.getFoodLevel() - s);
                    ++n4;
                }
                return;
            }
        }
    }

    @Override
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    public String toString() {
        return "the food level of " + this.players;
    }

    @Override
    public boolean isSingle() {
        return this.players.isSingle();
    }
}

