/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.TriggerFileLoader;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.exception.ParseException;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Utils;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class VarDrops
extends SimpleVariable<ItemStack> {
    static {
        Skript.registerVariable(VarDrops.class, ItemStack.class, "drops");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) throws ParseException {
        if (Utils.contains(TriggerFileLoader.currentEvents, EntityDeathEvent.class) == -1) {
            throw new ParseException("'drops' can only be used in death events");
        }
    }

    protected ItemStack[] getAll(Event e) {
        if (!(e instanceof EntityDeathEvent)) {
            return null;
        }
        return ((EntityDeathEvent)e).getDrops().toArray(new ItemStack[0]);
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return ItemType.class;
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) {
        if (!(e instanceof EntityDeathEvent)) {
            return;
        }
        List drops = ((EntityDeathEvent)e).getDrops();
        switch (mode) {
            case SET: {
                drops.clear();
            }
            case ADD: {
                ItemType[] itemTypeArray = (ItemType[])delta.getArray(e);
                int n = itemTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemType i = itemTypeArray[n2];
                    i.addTo(drops);
                    ++n2;
                }
                break;
            }
            case REMOVE: {
                ItemType[] itemTypeArray = (ItemType[])delta.getArray(e);
                int n = itemTypeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ItemType i = itemTypeArray[n3];
                    i.removeFrom(drops);
                    ++n3;
                }
                break;
            }
            case CLEAR: {
                drops.clear();
            }
        }
    }

    @Override
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return "drops";
        }
        return Skript.getDebugMessage(this.getAll(e));
    }

    @Override
    public String toString() {
        return "the drops";
    }

    @Override
    public boolean isSingle() {
        return false;
    }
}

