/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.data.DefaultChangers;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Offset;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class VarBlock
extends SimpleVariable<Block> {
    private Variable<Offset> offsets;
    private Variable<Block> blocks;

    static {
        Skript.registerVariable(VarBlock.class, Block.class, "block[[s] %-offsets% [%blocks%]]");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.offsets = vars[0];
        this.blocks = vars[1];
    }

    @Override
    public String getDebugMessage(Event e) {
        if (this.offsets == null) {
            return this.blocks.getDebugMessage(e);
        }
        return "block" + (this.isSingle() ? "" : "s") + " " + this.offsets.getDebugMessage(e) + " " + this.blocks.getDebugMessage(e);
    }

    protected Block[] getAll(Event e) {
        if (this.offsets == null) {
            return this.blocks.getArray(e);
        }
        return Offset.setOff(this.offsets.getArray(e), this.blocks.getArray(e));
    }

    @Override
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return DefaultChangers.blockChanger.acceptChange(mode);
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        DefaultChangers.blockChanger.change(e, this, delta, mode);
    }

    @Override
    public String toString() {
        if (this.offsets == null) {
            return "the block";
        }
        return "the block" + (this.isSingle() ? "" : "s") + " " + this.offsets + " " + this.blocks;
    }

    @Override
    public boolean isSingle() {
        return (this.offsets == null || this.offsets.isSingle()) && this.blocks.isSingle();
    }
}

