/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.api.exception.ParseException;
import ch.njol.skript.api.intern.ConvertedVariable;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.SkriptCommandEvent;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import org.bukkit.event.Event;

public class VarArgument
extends SimpleVariable<Object> {
    private Class<?> type = Object.class;
    private Argument<?> arg;
    private int a = -1;

    static {
        Skript.registerVariable(VarArgument.class, Object.class, "last arg[ument]", "arg[ument](-| )<(\\d+)>", "<(\\d*1)st|(\\d*2)nd|(\\d*3)rd|(\\d*[4-90])th> arg[ument]", "arg[ument]s");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) throws ParseException {
        if (Commands.currentArguments == null) {
            throw new ParseException("the variable 'argument' can only be used within a command");
        }
        if (Commands.currentArguments.size() == 0) {
            throw new ParseException("the command doesn't allow any arguments");
        }
        switch (matchedPattern) {
            case 0: {
                this.a = Commands.currentArguments.size();
                this.arg = Commands.currentArguments.get(this.a - 1);
                this.type = this.arg.getType();
                break;
            }
            case 1: 
            case 2: {
                this.a = Integer.parseInt(parser.regexes.get(0).group(1));
                if (Commands.currentArguments.size() <= this.a - 1) {
                    throw new ParseException("the command doesn't have a " + StringUtils.fancyOrderNumber(this.a) + " argument");
                }
                this.arg = Commands.currentArguments.get(this.a - 1);
                this.type = this.arg.getType();
                break;
            }
            case 3: {
                if (Commands.currentArguments.size() == 1) {
                    this.arg = Commands.currentArguments.get(0);
                    this.type = this.arg.getType();
                    break;
                }
                throw new ParseException("'arguments' cannot be used if the command has multiple arguments");
            }
        }
    }

    @Override
    protected Object[] getAll(Event e) {
        if (!(e instanceof SkriptCommandEvent)) {
            return null;
        }
        if (this.arg == null) {
            ArrayList r = new ArrayList(((SkriptCommandEvent)e).getSkriptCommand().getArguments().size());
            for (Argument<?> a : ((SkriptCommandEvent)e).getSkriptCommand().getArguments()) {
                ?[] objArray = a.getCurrent();
                int n = objArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objArray[n2];
                    r.add(o);
                    ++n2;
                }
            }
            return r.toArray();
        }
        return this.arg.getCurrent();
    }

    @Override
    public <R> ConvertedVariable<Object, ? extends R> getConvertedVar(Class<R> to) {
        if (this.arg != null) {
            return super.getConvertedVar(to);
        }
        return null;
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.type;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return this.a == -1 ? "arguments" : String.valueOf(StringUtils.fancyOrderNumber(this.a)) + " argument";
        }
        return Skript.getDebugMessage(this.getArray(e));
    }

    @Override
    public String toString() {
        if (this.a == -1) {
            return "the arguments";
        }
        return "the " + StringUtils.fancyOrderNumber(this.a) + " argument";
    }

    @Override
    public boolean isSingle() {
        return this.arg.isSingle();
    }
}

