/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Debuggable;
import ch.njol.skript.api.exception.ParseException;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Variable;
import java.util.ArrayList;
import org.bukkit.event.Event;

public class VariableString
implements Debuggable {
    private final ArrayList<Object> string = new ArrayList();
    private Event last = null;
    private String lastString = null;
    private final boolean isSimple;

    public VariableString(String s) throws ParseException {
        if (!s.contains("%")) {
            this.lastString = s;
            this.isSimple = true;
            return;
        }
        int c = s.indexOf(37);
        this.string.add(s.substring(0, c));
        while (c != s.length()) {
            int c2 = s.indexOf(37, c + 1);
            if (c2 == -1) {
                Skript.error("The percent sign is used for variables (e.g. %player%). To insert a %, type it twice: %%. (found in \"" + s + "\")");
                this.isSimple = true;
                return;
            }
            if (c + 1 == c2) {
                this.string.add("%");
            } else {
                Variable var = (Variable)ExprParser.parse(s.substring(c + 1, c2), Skript.getVariables().iterator(), false);
                if (var == null) {
                    throw new ParseException("can't understand the variable %" + s.substring(c + 1, c2) + "%");
                }
                this.string.add(var);
            }
            c = s.indexOf(37, c2 + 1);
            if (c == -1) {
                c = s.length();
            }
            this.string.add(s.substring(c2 + 1, c));
        }
        this.isSimple = false;
    }

    public static VariableString[] makeStrings(String[] args) {
        VariableString[] strings = new VariableString[args.length];
        int i = 0;
        while (i < args.length) {
            try {
                strings[i] = new VariableString(args[i]);
            }
            catch (ParseException e) {
                Skript.error(e.getError());
            }
            ++i;
        }
        return strings;
    }

    public static VariableString[] makeStringsFromQuoted(String[] args) {
        VariableString[] strings = new VariableString[args.length];
        int i = 0;
        while (i < args.length) {
            try {
                strings[i] = new VariableString(args[i].substring(1, args[i].length() - 1));
            }
            catch (ParseException e) {
                Skript.error(e.getError());
            }
            ++i;
        }
        return strings;
    }

    public String get(Event e) {
        if (this.isSimple || this.last == e) {
            return this.lastString;
        }
        StringBuilder b = new StringBuilder();
        for (Object o : this.string) {
            if (o instanceof Variable) {
                if (((Variable)o).isSingle()) {
                    b.append(Skript.toString(((Variable)o).getSingle(e)));
                    continue;
                }
                b.append(Skript.toString(((Variable)o).getArray(e), ((Variable)o).getAnd()));
                continue;
            }
            b.append(o);
        }
        this.last = e;
        this.lastString = b.toString();
        return this.lastString;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (this.isSimple) {
            return String.valueOf('\"') + this.lastString + '\"';
        }
        StringBuilder b = new StringBuilder("\"");
        for (Object o : this.string) {
            if (o instanceof Variable) {
                b.append("%" + ((Variable)o).getDebugMessage(e) + "%");
                continue;
            }
            b.append(o);
        }
        b.append('\"');
        return b.toString();
    }

    public boolean isSimple() {
        return this.isSimple;
    }
}

