/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.util.VariableString;
import ch.njol.util.Pair;
import ch.njol.util.Validate;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public abstract class Utils {
    private static final String[][] plurals = new String[][]{{"f", "ves"}, {"y", "ies"}, {"man", "men"}, {"s", "ses"}, {"us", "i"}};

    private Utils() {
    }

    public static boolean parseBoolean(String s) {
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes")) {
            return true;
        }
        if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no")) {
            return false;
        }
        Skript.error("'" + s + "' is not a boolean (true/yes or false/no)");
        return false;
    }

    public static byte parseBooleanNoError(String s) {
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes")) {
            return 1;
        }
        if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no")) {
            return 0;
        }
        return -1;
    }

    public static short parseShort(String s) {
        try {
            return Short.parseShort(s);
        }
        catch (NumberFormatException e) {
            Skript.error("'" + s + "' is not an integer between -32768 and 32767");
            return 0;
        }
    }

    public static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            Skript.error("'" + s + "' is not an integer");
            return 0;
        }
    }

    public static float parseFloat(String s) {
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            Skript.error("'" + s + "' is not a number");
            return 0.0f;
        }
    }

    public static double parseDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            Skript.error("'" + s + "' is not a number");
            return 0.0;
        }
    }

    public static <T> int contains(T[] array, T o) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int contains(int[] array, int num) {
        return Utils.contains(array, num, 0, array.length);
    }

    public static int contains(int[] array, int num, int start) {
        return Utils.contains(array, num, start, array.length);
    }

    public static int contains(int[] array, int num, int start, int end) {
        if (array == null) {
            return -1;
        }
        int i = start;
        while (i < end) {
            if (array[i] == num) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int containsIgnoreCase(String[] array, String s) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (a.equalsIgnoreCase(s)) {
                return i;
            }
            ++i;
            ++n2;
        }
        return -1;
    }

    public static <T> int contains(Iterable<T> array, T o) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        for (T a : array) {
            if (a.equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int containsIgnoreCase(Iterable<String> array, String s) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        for (String a : array) {
            if (a.equalsIgnoreCase(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T, U> Map.Entry<T, U> containsKey(Map<T, U> m, T key) {
        if (m == null) {
            return null;
        }
        U u = m.get(key);
        if (u == null) {
            return null;
        }
        return new Pair<T, U>(key, u);
    }

    public static <U> Map.Entry<String, U> containsKeyIgnoreCase(Map<String, U> m, String key) {
        if (m == null) {
            return null;
        }
        for (Map.Entry<String, U> e : m.entrySet()) {
            if (!e.getKey().equalsIgnoreCase(key)) continue;
            return e;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BlockFace getBlockFace(String s, boolean printError) {
        String supper;
        block19: {
            if (s == null || s.isEmpty()) {
                return null;
            }
            supper = s.toUpperCase(Locale.ENGLISH).replace(' ', '_');
            try {
                if (supper.equals("ABOVE")) {
                    return BlockFace.UP;
                }
                if (supper.equals("BELOW")) {
                    return BlockFace.DOWN;
                }
                return BlockFace.valueOf((String)supper);
            }
            catch (IllegalArgumentException e1) {
                if (supper.equals("U")) {
                    return BlockFace.UP;
                }
                if (supper.equals("D")) {
                    return BlockFace.DOWN;
                }
                if (supper.length() > 3) break block19;
                try {
                    String r = "";
                    int i = 0;
                    while (true) {
                        if (i >= supper.length()) {
                            return BlockFace.valueOf((String)r.substring(0, r.length() - 1));
                        }
                        switch (supper.charAt(i)) {
                            case 'N': {
                                r = String.valueOf(r) + "NORTH_";
                                break;
                            }
                            case 'E': {
                                r = String.valueOf(r) + "EAST_";
                                break;
                            }
                            case 'S': {
                                r = String.valueOf(r) + "SOUTH_";
                                break;
                            }
                            case 'W': {
                                r = String.valueOf(r) + "WEST_";
                                break;
                            }
                            default: {
                                if (printError) {
                                    Skript.error("invalid direction '" + s + "'");
                                }
                                return null;
                            }
                        }
                        ++i;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (printError) {
            Skript.error("invalid direction '" + supper + "'");
        }
        return null;
    }

    public static final int[] getBlockFaceDir(BlockFace f) {
        return new int[]{f.getModX(), f.getModY(), f.getModZ()};
    }

    public static final int getBlockFaceDir(BlockFace f, int axis) {
        switch (axis) {
            case 0: {
                return f.getModX();
            }
            case 1: {
                return f.getModY();
            }
            case 2: {
                return f.getModZ();
            }
        }
        throw new IllegalArgumentException("axis must be between 0 and 2");
    }

    public static String join(VariableString[] strings, Event e, boolean and) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < strings.length) {
            if (i != 0) {
                if (i != strings.length - 1) {
                    b.append(", ");
                } else {
                    b.append(and ? " and " : " or ");
                }
            }
            b.append(strings[i].getDebugMessage(e));
            ++i;
        }
        return b.toString();
    }

    public static String join(String[] strings) {
        return Utils.join(strings, ", ");
    }

    public static String join(String[] strings, String delimiter) {
        return Utils.join(strings, delimiter, 0, strings.length);
    }

    public static String join(String[] strings, String delimiter, int start, int end) {
        StringBuilder b = new StringBuilder();
        int i = start;
        while (i < end) {
            if (i != 0) {
                b.append(delimiter);
            }
            b.append(strings[i]);
            ++i;
        }
        return b.toString();
    }

    public static String join(Object[] objects) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < objects.length) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(Skript.toString(objects[i]));
            ++i;
        }
        return b.toString();
    }

    public static String join(List<?> objects) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < objects.size()) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(Skript.toString(objects.get(i)));
            ++i;
        }
        return b.toString();
    }

    public static <T> T getRandom(T[] os) {
        if (os == null || os.length == 0) {
            return null;
        }
        return os[Skript.random.nextInt(os.length)];
    }

    public static <T> T getRandom(T[] os, int start) {
        if (os == null || os.length == 0) {
            return null;
        }
        return os[Skript.random.nextInt(os.length - start) + start];
    }

    public static <T> T getRandom(List<T> os) {
        if (os == null || os.size() == 0) {
            return null;
        }
        return os.get(Skript.random.nextInt(os.size()));
    }

    public static boolean itemStacksEqual(ItemStack is1, ItemStack is2) {
        if (is1 == null || is2 == null) {
            return is1 == is2;
        }
        return is1.getTypeId() == is2.getTypeId() && is1.getDurability() == is2.getDurability();
    }

    public static final ItemStack remove(ItemStack what, ItemStack from) {
        if (what == null || from == null || !Utils.itemStacksEqual(what, from)) {
            return from;
        }
        from.setAmount(Math.max(from.getAmount() - what.getAmount(), 0));
        return from;
    }

    public static final ItemStack add(ItemStack what, ItemStack to) {
        if (what == null || to == null || !Utils.itemStacksEqual(what, to)) {
            return to;
        }
        to.setAmount(Math.max(to.getAmount() + what.getAmount(), 0));
        return to;
    }

    public static Player getTargetPlayer(Player player) {
        return (Player)Utils.getTarget((LivingEntity)player, player.getWorld().getPlayers());
    }

    public static Entity getTargetEntity(LivingEntity entity, Class<? extends Entity> type) {
        if (entity instanceof Creature) {
            return ((Creature)entity).getTarget();
        }
        return Utils.getTarget(entity, entity.getWorld().getEntitiesByClass(type));
    }

    public static <T extends Entity> T getTarget(LivingEntity entity, Iterable<T> entities) {
        if (entity == null) {
            return null;
        }
        Entity target = null;
        double targetDistanceSquared = Double.MAX_VALUE;
        double radiusSquared = 1.0;
        Vector l = entity.getEyeLocation().toVector();
        Vector n = entity.getLocation().getDirection().normalize();
        double cos = Math.cos(0.7853981633974483);
        for (Entity other : entities) {
            if (other == entity || target != null && !(targetDistanceSquared > other.getLocation().distanceSquared(entity.getLocation()))) continue;
            Vector t = other.getLocation().toVector().subtract(l);
            if (!(n.clone().crossProduct(t).lengthSquared() < 1.0) || !(t.normalize().dot(n) >= cos)) continue;
            target = other;
            targetDistanceSquared = target.getLocation().distanceSquared(entity.getLocation());
        }
        return (T)target;
    }

    public static final Pair<String, Integer> getAmount(String s) {
        if (s.matches("\\d+ of .+")) {
            return new Pair<String, Integer>(s.split(" ", 3)[2], Integer.valueOf(s.split(" ", 2)[0]));
        }
        if (s.matches("\\d+ .+")) {
            return new Pair<String, Integer>(s.split(" ", 2)[1], Integer.valueOf(s.split(" ", 2)[0]));
        }
        if (s.matches("an? .+")) {
            return new Pair<String, Integer>(s.split(" ", 2)[1], 1);
        }
        return new Pair<String, Integer>(s, -1);
    }

    public static final AmountResponse getAmountWithEvery(String s) {
        if (s.matches("\\d+ of (all|every) .+")) {
            return new AmountResponse(s.split(" ", 4)[3], Integer.parseInt(s.split(" ", 2)[0]), true);
        }
        if (s.matches("\\d+ of .+")) {
            return new AmountResponse(s.split(" ", 3)[2], Integer.parseInt(s.split(" ", 2)[0]));
        }
        if (s.matches("\\d+ .+")) {
            return new AmountResponse(s.split(" ", 2)[1], Integer.parseInt(s.split(" ", 2)[0]));
        }
        if (s.matches("an? .+")) {
            return new AmountResponse(s.split(" ", 2)[1], 1);
        }
        if (s.matches("(all|every) .+")) {
            return new AmountResponse(s.split(" ", 2)[1], true);
        }
        return new AmountResponse(s);
    }

    public static Pair<String, Boolean> getPlural(String s, boolean expectPlural) {
        Pair<String, Boolean> p = Utils.getPlural(s);
        if ((Boolean)p.second != expectPlural) {
            Skript.warning("Possible invalid plural detected in '" + s + "'");
        }
        return p;
    }

    public static final Pair<String, Boolean> getPlural(String s) {
        Validate.notNullOrEmpty(s, "s");
        String[][] stringArray = plurals;
        int n = plurals.length;
        int n2 = 0;
        while (n2 < n) {
            String[] p = stringArray[n2];
            if (s.endsWith(p[1])) {
                return new Pair<String, Boolean>(String.valueOf(s.substring(0, s.length() - p[1].length())) + p[0], Boolean.TRUE);
            }
            if (s.endsWith(p[1].toUpperCase())) {
                return new Pair<String, Boolean>(String.valueOf(s.substring(0, s.length() - p[1].length())) + p[0].toUpperCase(), Boolean.TRUE);
            }
            ++n2;
        }
        if (s.endsWith("s") || s.endsWith("S")) {
            return new Pair<String, Boolean>(s.substring(0, s.length() - 1), Boolean.TRUE);
        }
        return new Pair<String, Boolean>(s, Boolean.FALSE);
    }

    public static final String toPlural(String s) {
        Validate.notNullOrEmpty(s, "s");
        String[][] stringArray = plurals;
        int n = plurals.length;
        int n2 = 0;
        while (n2 < n) {
            String[] p = stringArray[n2];
            if (s.endsWith(p[0])) {
                return String.valueOf(s.substring(0, s.length() - p[0].length())) + p[1];
            }
            ++n2;
        }
        return String.valueOf(s) + (Character.isLowerCase(s.charAt(s.length() - 1)) ? "s" : "S");
    }

    public static final String a(String s) {
        return Utils.a(s, false);
    }

    public static final String a(String s, boolean capA) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        switch (Character.toLowerCase(s.charAt(0))) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                if (capA) {
                    return "An " + s;
                }
                return "an " + s;
            }
        }
        if (capA) {
            return "A " + s;
        }
        return "a " + s;
    }

    public static double getBlockHeight(Material type) {
        switch (type) {
            case DIODE_BLOCK_OFF: 
            case DIODE_BLOCK_ON: {
                return 0.125;
            }
            case TRAP_DOOR: {
                return 0.1875;
            }
            case CAKE_BLOCK: {
                return 0.4375;
            }
            case STEP: {
                return 0.5;
            }
            case BED_BLOCK: {
                return 0.5625;
            }
            case ENCHANTMENT_TABLE: {
                return 0.75;
            }
            case ENDER_PORTAL_FRAME: {
                return 0.8125;
            }
            case SOUL_SAND: {
                return 0.875;
            }
            case BREWING_STAND: {
                return 0.875;
            }
            case FENCE: 
            case FENCE_GATE: 
            case NETHER_FENCE: {
                return 1.5;
            }
            case CAULDRON: {
                return 0.3125;
            }
        }
        return 1.0;
    }

    public static final class AmountResponse {
        public final String s;
        public final int amount;
        public final boolean every;

        public AmountResponse(String s, int amount, boolean every) {
            this.s = s;
            this.amount = amount;
            this.every = every;
        }

        public AmountResponse(String s, boolean every) {
            this.s = s;
            this.amount = -1;
            this.every = every;
        }

        public AmountResponse(String s, int amount) {
            this.s = s;
            this.amount = amount;
            this.every = false;
        }

        public AmountResponse(String s) {
            this.s = s;
            this.amount = -1;
            this.every = false;
        }
    }
}

