/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.api.ClassInfo;
import ch.njol.skript.api.Parser;
import java.util.HashMap;
import java.util.Locale;

public class Timespan {
    private final float ticks;

    static {
        HashMap<String, Float> simpleValues = new HashMap<String, Float>();
        simpleValues.put("year", Float.valueOf(8640000.0f));
        simpleValues.put("month", Float.valueOf(720000.0f));
        simpleValues.put("week", Float.valueOf(168000.0f));
        simpleValues.put("day", Float.valueOf(24000.0f));
        simpleValues.put("hour", Float.valueOf(1000.0f));
        simpleValues.put("minute", Float.valueOf(16.666666f));
        simpleValues.put("tick", Float.valueOf(1.0f));
        simpleValues.put("second", Float.valueOf(0.2777778f));
        Skript.registerClass(new ClassInfo<Timespan>("timespan", Timespan.class, null, new Parser<Timespan>(){

            @Override
            public Timespan parse(String s) {
                if (s.isEmpty()) {
                    return null;
                }
                s = s.toLowerCase(Locale.ENGLISH);
                float t = 0.0f;
                if (s.matches("^\\d+(:\\d\\d){1,2}$")) {
                    String[] ss = s.split(":");
                    float[] times = new float[]{1000.0f, 16.666666f, 0.2777778f};
                    int i = 0;
                    while (i < ss.length) {
                        t += times[i] * (float)Integer.parseInt(ss[i]);
                        ++i;
                    }
                } else {
                    String[] subs = s.split("\\s+");
                    int i = 0;
                    while (i < subs.length) {
                        String sub = subs[i];
                        if (sub.equals("and")) {
                            if (i == 0) {
                                return null;
                            }
                        } else {
                            int amount = 1;
                            if (sub.matches("^\\d+$")) {
                                if (i == subs.length) {
                                    return null;
                                }
                                amount = Integer.parseInt(sub);
                                sub = subs[++i];
                            }
                            if (sub.equals("real") || sub.equals("rl") || sub.equals("irl")) {
                                if (i == subs.length) {
                                    return null;
                                }
                                amount *= 72;
                                sub = subs[++i];
                            }
                            if (sub.endsWith(",")) {
                                sub = sub.substring(0, sub.length() - 1);
                            }
                            if (amount == 1 && sub.endsWith("s") || amount != 1 && !sub.endsWith("s")) {
                                return null;
                            }
                            if (amount != 1) {
                                sub = sub.substring(0, sub.length() - 1);
                            }
                            if (!simpleValues.containsKey(sub)) {
                                return null;
                            }
                            t += (float)amount * ((Float)simpleValues.get(sub)).floatValue();
                        }
                        ++i;
                    }
                }
                return new Timespan(t);
            }

            @Override
            public String toString(Timespan t) {
                return String.valueOf(Math.floor(t.ticks / 1000.0f)) + ":" + Math.floor(t.ticks % 1000.0f * 60.0f / 1000.0f);
            }
        }));
    }

    public Timespan() {
        this.ticks = 0.0f;
    }

    public Timespan(float ticks) {
        this.ticks = ticks;
    }

    public float getTicks() {
        return this.ticks;
    }
}

