/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.SkriptLogger;
import java.util.Deque;
import java.util.LinkedList;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class ErrorSession {
    private final Deque<String> errors = new LinkedList<String>();
    private final Deque<String> warnings = new LinkedList<String>();
    private int errorCount = 0;

    public void warning(String warning) {
        if (this.errors.isEmpty()) {
            this.warnings.add(warning);
        }
    }

    public void error(String error) {
        this.warnings.clear();
        this.errors.add(error);
    }

    public void severeError(String error) {
        ++this.errorCount;
        SkriptLogger.log(Level.SEVERE, error);
    }

    public void printErrors(String def) {
        if (!this.hasErrors()) {
            SkriptLogger.log(Level.SEVERE, def);
        } else {
            this.printErrors();
        }
    }

    public void printErrors(CommandSender sender) {
        this.errorCount += this.errors.size();
        for (String error : this.errors) {
            if (sender != null) {
                sender.sendMessage(ChatColor.DARK_RED + error);
                continue;
            }
            SkriptLogger.log(Level.SEVERE, error);
        }
        this.errors.clear();
    }

    public void printErrors() {
        this.errorCount += this.errors.size();
        for (String error : this.errors) {
            SkriptLogger.log(Level.SEVERE, error);
        }
        this.errors.clear();
    }

    public final void printWarnings() {
        for (String w : this.warnings) {
            SkriptLogger.log(Level.WARNING, w);
        }
        this.warnings.clear();
    }

    public final void clearErrors() {
        this.warnings.clear();
        this.errors.clear();
    }

    public final boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public String getLastError() {
        return this.errors.peekLast();
    }
}

