/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class AABB
implements Iterable<Block> {
    private final World world;
    private final Vector lowerBound;
    private final Vector upperBound;

    public AABB(Location l1, Location l2) {
        if (l1.getWorld() != l2.getWorld()) {
            throw new IllegalArgumentException("Locations must be in the same world");
        }
        this.world = l1.getWorld();
        this.lowerBound = new Vector(Math.min(l1.getX(), l2.getX()), Math.min(l1.getY(), l2.getY()), Math.min(l1.getZ(), l2.getZ()));
        this.upperBound = new Vector(Math.max(l1.getX(), l2.getX()), Math.max(l1.getY(), l2.getY()), Math.max(l1.getZ(), l2.getZ()));
    }

    public AABB(Block b1, Block b2) {
        if (b1.getWorld() != b2.getWorld()) {
            throw new IllegalArgumentException("Blocks must be in the same world");
        }
        this.world = b1.getWorld();
        this.lowerBound = new Vector(Math.min(b1.getX(), b2.getX()), Math.min(b1.getY(), b2.getY()), Math.min(b1.getZ(), b2.getZ()));
        this.upperBound = new Vector(Math.max(b1.getX(), b2.getX()) + 1, Math.max(b1.getY(), b2.getY()) + 1, Math.max(b1.getZ(), b2.getZ()) + 1);
    }

    public AABB(Location center, double dimX, double dimY, double dimZ) {
        this.world = center.getWorld();
        this.lowerBound = new Vector(center.getX() - dimX / 2.0, center.getY() - dimY / 2.0, center.getZ() - dimZ / 2.0);
        this.upperBound = new Vector(center.getX() + dimX / 2.0, center.getY() + dimY / 2.0, center.getZ() + dimZ / 2.0);
    }

    public boolean contains(Location l) {
        if (l.getWorld() != this.world) {
            return false;
        }
        return this.lowerBound.getX() <= l.getX() && l.getX() <= this.upperBound.getX() && this.lowerBound.getY() <= l.getY() && l.getY() <= this.upperBound.getY() && this.lowerBound.getZ() <= l.getZ() && l.getZ() <= this.upperBound.getZ();
    }

    public boolean containsCompletely(Block b) {
        return this.contains(b.getLocation()) && this.contains(b.getLocation().add(1.0, 1.0, 1.0));
    }

    public boolean contains(Block b) {
        return this.contains(b.getLocation().add(0.5, 0.5, 0.5));
    }

    public Vector getDimensions() {
        return this.upperBound.clone().subtract(this.lowerBound);
    }

    @Override
    public Iterator<Block> iterator() {
        return new Iterator<Block>(){
            private int x;
            private int y;
            private int z;
            private final int maxX;
            private final int maxY;
            private final int maxZ;
            {
                this.x = (int)Math.round(AABB.this.lowerBound.getX()) - 1;
                this.y = (int)Math.round(AABB.this.lowerBound.getY());
                this.z = (int)Math.round(AABB.this.lowerBound.getZ());
                this.maxX = (int)Math.round(AABB.this.upperBound.getX()) - 1;
                this.maxY = (int)Math.round(AABB.this.upperBound.getY()) - 1;
                this.maxZ = (int)Math.round(AABB.this.upperBound.getZ()) - 1;
            }

            @Override
            public boolean hasNext() {
                return this.z < this.maxZ || this.y < this.maxY || this.x < this.maxX;
            }

            @Override
            public Block next() {
                ++this.x;
                if (this.x > this.maxX) {
                    this.x = 0;
                    ++this.y;
                    if (this.y > this.maxY) {
                        this.y = 0;
                        ++this.z;
                        if (this.z > this.maxZ) {
                            throw new IllegalStateException();
                        }
                    }
                }
                return AABB.this.world.getBlockAt(this.x, this.y, this.z);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

