/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.loops;

import ch.njol.skript.Skript;
import ch.njol.skript.api.LoopVar;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;
import ch.njol.util.iterator.ArrayIterator;
import ch.njol.util.iterator.CheckedIterator;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class LoopVarItem
extends LoopVar<ItemStack> {
    private Variable<ItemType> types = null;
    private boolean blocks = false;

    static {
        Skript.registerLoop(LoopVarItem.class, ItemStack.class, "[(all|every)] item(s|[ ]types)", "items of type[s] %itemtypes%", "[(all|every)] block(s|[ ]types)", "blocks of type[s] %itemtypes%");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        if (vars.length > 0) {
            this.types = vars[0];
        }
        boolean bl = this.blocks = matchedPattern >= 2;
        if (this.types instanceof Literal) {
            ItemType[] itemTypeArray = (ItemType[])((Literal)this.types).getArray();
            int n = itemTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemType t = itemTypeArray[n2];
                t.setAll(true);
                ++n2;
            }
        }
    }

    @Override
    protected Iterator<ItemStack> iterator(Event e) {
        Iterator<ItemStack> iter = this.types == null ? new Iterator<ItemStack>(){
            private final Iterator<Material> iter = new ArrayIterator<Material>(Material.values());

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public ItemStack next() {
                return new ItemStack(this.iter.next());
            }

            @Override
            public void remove() {
            }
        } : new Iterator<ItemStack>(e){
            private final Iterator<ItemType> iter;
            Iterator<ItemStack> current;
            {
                this.iter = new ArrayIterator<ItemType>((ItemType[])LoopVarItem.this.types.getArray(event));
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext() || this.current.hasNext();
            }

            @Override
            public ItemStack next() {
                if (this.current == null || !this.current.hasNext()) {
                    this.current = this.iter.next().getAll().iterator();
                }
                return this.current.next();
            }

            @Override
            public void remove() {
            }
        };
        if (!this.blocks) {
            return iter;
        }
        return new CheckedIterator<ItemStack>(iter, new Checker<ItemStack>(){

            @Override
            public boolean check(ItemStack is) {
                return is.getTypeId() <= 255;
            }
        });
    }

    @Override
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @Override
    public String getLoopDebugMessage(Event e) {
        return String.valueOf(this.blocks ? "blocks" : "items") + " of type " + this.types.getDebugMessage(e);
    }

    @Override
    public String toString() {
        return "the loop-" + (this.blocks ? "block" : "item");
    }

    @Override
    public boolean isLoopOf(String s) {
        return this.blocks && s.equalsIgnoreCase("block") || !this.blocks && s.equalsIgnoreCase("item");
    }
}

