/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.loops;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.LoopVar;
import ch.njol.skript.data.DefaultChangers;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.BlockSphereIterator;
import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class LoopVarBlockSphere
extends LoopVar<Block> {
    private Variable<Float> radius;
    private Variable<Location> center;

    static {
        Skript.registerLoop(LoopVarBlockSphere.class, Block.class, "blocks in radius %float% [around %location%]");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.radius = vars[0];
        this.center = vars[1];
    }

    @Override
    protected Iterator<Block> iterator(Event e) {
        return new BlockSphereIterator(this.center.getSingle(e), this.radius.getSingle(e).floatValue());
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return DefaultChangers.blockChanger.acceptChange(mode);
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) {
        DefaultChangers.blockChanger.change(e, this, delta, mode);
    }

    @Override
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    @Override
    public String getLoopDebugMessage(Event e) {
        return "blocks in radius " + this.radius.getDebugMessage(e) + " around " + this.center.getDebugMessage(e);
    }

    @Override
    public String toString() {
        return "the loop-block";
    }

    @Override
    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("block");
    }
}

