/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.loops;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.LoopVar;
import ch.njol.skript.api.intern.Variable;
import ch.njol.skript.data.DefaultChangers;
import ch.njol.skript.util.BlockSphereIterator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class LoopVarBlock
extends LoopVar<Block> {
    private Variable<Float> radii;
    private Variable<Location> centers;

    static {
        Skript.addLoop(LoopVarBlock.class, Block.class, (String[])new String[]{"blocks in (radius|radii|radiuses) %float%( around %location%)?"});
    }

    public void init(List<Variable<?>> vars, int matchedPattern, Matcher matcher) {
        this.radii = vars.get(0);
        this.centers = vars.get(1);
    }

    protected Iterator<Block> iterator(Event e) {
        return new BlockSphereIterator((Location)this.centers.getFirst(e), ((Float)this.radii.getFirst(e)).floatValue());
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return DefaultChangers.blockChanger.acceptChange(mode);
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) {
        DefaultChangers.blockChanger.change(e, (Variable)this, delta, mode);
    }

    @Override
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return "blocks in radius " + this.radii.getDebugMessage(e) + " around " + this.centers.getDebugMessage(e);
        }
        return Skript.toString((Block[])this.get(e));
    }

    @Override
    public String toString() {
        return "the loop-block";
    }

    @Override
    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("block");
    }
}

