/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Converter;
import ch.njol.skript.api.DefaultVariable;
import ch.njol.skript.api.intern.ConvertedLiteral;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import java.lang.reflect.Array;
import org.bukkit.event.Event;

public class SimpleLiteral<T>
extends SimpleVariable<T>
implements Literal<T>,
DefaultVariable<T> {
    protected final T[] data;
    protected final Class<T> c;

    public SimpleLiteral(T[] data, Class<T> c, boolean and) {
        this.data = data;
        this.c = c;
        this.setAnd(and);
    }

    public SimpleLiteral(T data) {
        this.data = (Object[])Array.newInstance(data.getClass(), 1);
        this.data[0] = data;
        this.c = data.getClass();
        this.setAnd(true);
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void init() {
    }

    @Override
    protected T[] getAll(Event e) {
        return this.data;
    }

    @Override
    public T[] getArray() {
        return this.getArray(null);
    }

    @Override
    public T getSingle() {
        return this.getSingle(null);
    }

    @Override
    public Class<T> getReturnType() {
        return this.c;
    }

    @Override
    public <R> ConvertedLiteral<T, ? extends R> getConvertedVar(Class<R> to) {
        if (to.isAssignableFrom(this.c)) {
            return new ConvertedLiteral(this, this.getAll(null), to);
        }
        Converter<T, R> p = Skript.getConverter(this.c, to);
        if (p == null) {
            return null;
        }
        Object[] parsedData = (Object[])Array.newInstance(to, this.data.length);
        int i = 0;
        while (i < this.data.length) {
            parsedData[i] = p.convert(this.data[i]);
            ++i;
        }
        return new ConvertedLiteral(this, parsedData, to);
    }

    @Override
    public String getDebugMessage(Event e) {
        return "[" + this + "]";
    }

    @Override
    public String toString() {
        return Skript.toString(this.data, this.getAnd());
    }

    @Override
    public boolean isSingle() {
        return !this.getAnd() || this.data.length <= 1;
    }
}

