/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.api.exception.InitException;
import ch.njol.skript.api.exception.ParseException;
import ch.njol.skript.api.intern.ConvertedLiteral;
import ch.njol.skript.api.intern.SkriptAPIException;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Utils;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExprParser {
    private final String expr;
    final boolean parseStatic;
    private String bestError = null;
    private int bestErrorQuality = 0;
    public static final String wildcard = "[^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?";
    public static final String stringMatcher = "\"[^\"]*?(?:\"\"[^\"]*)*?\"";

    private ExprParser(String expr) {
        this.expr = expr;
        this.parseStatic = false;
    }

    private ExprParser(String expr, boolean parseStatic) {
        this.expr = expr;
        this.parseStatic = parseStatic;
    }

    public static final <T> Literal<? extends T> parseLiteral(String expr, Class<T> c) {
        UnparsedLiteral l = ExprParser.parseUnparsedLiteral(expr);
        if (l == null) {
            return null;
        }
        return l.getConvertedVar(c);
    }

    public static final Expression parse(String expr, Iterator<? extends ExpressionInfo<?>> source, boolean parseLiteral) {
        Expression e = ExprParser.parse(expr, source);
        if (e != null) {
            return e;
        }
        if (parseLiteral) {
            return ExprParser.parseUnparsedLiteral(expr);
        }
        return null;
    }

    public static final Expression parse(String expr, Iterator<? extends ExpressionInfo<?>> source) {
        return new ExprParser(expr).parse(source);
    }

    /*
     * Unable to fully structure code
     */
    private final Expression parse(Iterator<? extends ExpressionInfo<?>> source) {
        if (Skript.getCurrentErrorSession() != null) ** GOTO lbl48
        throw new SkriptAPIException("must start an ErrorSession before trying to parse anything!");
lbl-1000:
        // 1 sources

        {
            info = source.next();
            i = 0;
            while (i < info.patterns.length) {
                try {
                    res = this.parse_i(info.patterns[i], 0, 0);
                    if (res != null) {
                        x = -1;
                        j = 0;
                        while ((x = ExprParser.next(info.patterns[i], '%', x + 1)) != -1) {
                            x2 = ExprParser.next(info.patterns[i], '%', x + 1);
                            if (res.vars[j] == null && !(name = info.patterns[i].substring(x + 1, x2)).startsWith("-")) {
                                p = Utils.getPlural(name);
                                name = (String)p.first;
                                var = Skript.getDefaultVariable(name);
                                if (var == null) {
                                    throw new SkriptAPIException("The class '" + name + "' does not provide a default variable. Either allow null (with %-" + name + "%) or make it mandatory");
                                }
                                if (!((Boolean)p.second).booleanValue() && !var.isSingle()) {
                                    throw new SkriptAPIException("The default variable of '" + name + "' is not a single-element variable. Change your pattern to allow multiple elements or make the variable mandatory");
                                }
                                var.init();
                                res.vars[j] = var;
                            }
                            x = x2;
                            ++j;
                        }
                        Skript.getCurrentErrorSession().clearErrors();
                        e = (Expression)info.c.newInstance();
                        e.init(res.vars, i, res);
                        return e;
                    }
                }
                catch (ParseException e) {
                    if (e.getError() != null) {
                        Skript.error(e.getError());
                    }
                    if (this.bestErrorQuality < 100) {
                        this.bestError = e.getError();
                        this.bestErrorQuality = 100;
                    }
                    return null;
                }
                catch (InstantiationException e) {
                    SkriptAPIException.instantiationException("the " + Skript.getExpressionName(info.c), info.c, e);
                }
                catch (IllegalAccessException e) {
                    SkriptAPIException.inaccessibleConstructor(info.c, e);
                }
                catch (InitException e) {
                    Skript.getCurrentErrorSession().clearErrors();
                }
                ++i;
            }
lbl48:
            // 2 sources

            ** while (source.hasNext())
        }
lbl49:
        // 1 sources

        if (this.bestError != null) {
            Skript.error(this.bestError);
        }
        return null;
    }

    private final Variable<?> parseVar(Class<?> returnType, String expr, boolean literalOnly) {
        UnparsedLiteral l;
        if (!literalOnly) {
            ExprParser parser = new ExprParser(expr);
            Variable v = (Variable)parser.parse(Skript.getVariables().iterator());
            if (v != null) {
                Variable<?> w = v.getConvertedVariable(returnType);
                if (w == null && this.bestErrorQuality < 90) {
                    this.bestError = String.valueOf(v.toString()) + " " + (v.isSingle() ? "is" : "are") + " not " + Utils.a(Skript.getExactClassName(returnType));
                    this.bestErrorQuality = 90;
                }
                return w;
            }
            if (parser.bestErrorQuality > this.bestErrorQuality) {
                this.bestError = parser.bestError;
                this.bestErrorQuality = parser.bestErrorQuality;
            }
        }
        if ((l = ExprParser.parseUnparsedLiteral(expr)) == null || returnType == Object.class) {
            return l;
        }
        Skript.getCurrentErrorSession().clearErrors();
        ConvertedLiteral<Object, ?> p = l.getConvertedVar(returnType);
        if (p == null && this.bestErrorQuality < 90) {
            this.bestError = Skript.getCurrentErrorSession().getLastError();
            this.bestErrorQuality = 90;
        }
        return p;
    }

    public static Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> parseEvent(String event) {
        return new ExprParser(event, true).parseEvent();
    }

    private Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> parseEvent() {
        if (Skript.getCurrentErrorSession() == null) {
            throw new SkriptAPIException("must start an ErrorSession before trying to parse anything!");
        }
        for (SkriptEvent.SkriptEventInfo<?> info : Skript.getEvents()) {
            int i = 0;
            while (i < info.patterns.length) {
                try {
                    ParseResult res = this.parse_i(info.patterns[i], 0, 0);
                    if (res != null) {
                        Skript.getCurrentErrorSession().clearErrors();
                        SkriptEvent e = (SkriptEvent)info.c.newInstance();
                        e.init((Literal[])Arrays.copyOf(res.vars, res.vars.length, Literal[].class), i, res);
                        return new Pair(info, e);
                    }
                }
                catch (ParseException e) {
                    if (e.getError() != null) {
                        Skript.error(e.getError());
                    }
                    return null;
                }
                catch (InstantiationException e) {
                    SkriptAPIException.instantiationException("the event", info.c, e);
                }
                catch (IllegalAccessException e) {
                    SkriptAPIException.inaccessibleConstructor(info.c, e);
                }
                ++i;
            }
        }
        if (this.bestError != null) {
            Skript.error(this.bestError);
        }
        return null;
    }

    private static int next(String s, char c, char x, int start) {
        int n = 0;
        int i = start;
        while (i < s.length()) {
            if (s.charAt(i) == '\\') {
                ++i;
            } else if (s.charAt(i) == c) {
                if (n == 0) {
                    return i;
                }
                --n;
            } else if (s.charAt(i) == x) {
                ++n;
            }
            ++i;
        }
        throw new MalformedPatternException(s, "missing closing bracket '" + x + "'");
    }

    private static int next(String s, char c, int from) {
        int i = from;
        while (i < s.length()) {
            if (s.charAt(i) == '\\') {
                ++i;
            } else if (s.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int nextQuote(String s, int from) {
        int i = from;
        while (i < s.length()) {
            if (s.charAt(i) == '\"') {
                if (i == s.length() - 1 || s.charAt(i + 1) != '\"') {
                    return i;
                }
                ++i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean hasOnly(String s, String what, int start, int end) {
        int i = start;
        while (i < end) {
            if (what.indexOf(s.charAt(i)) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final ParseResult parse_i(String pattern, int i, int j) throws ParseException {
        if (this.expr.isEmpty()) {
            throw new RuntimeException(pattern);
        }
        int matchedChars = 0;
        while (j < pattern.length()) {
            switch (pattern.charAt(j)) {
                case '[': {
                    ParseResult res = this.parse_i(pattern, i, j + 1);
                    if (res != null) {
                        return res;
                    }
                    int end = ExprParser.next(pattern, ']', '[', j + 1);
                    if ((ExprParser.hasOnly(pattern, "[(", 0, j) || pattern.charAt(j - 1) == ' ') && end < pattern.length() - 1 && pattern.charAt(end + 1) == ' ') {
                        ++end;
                    }
                    j = end + 1;
                    break;
                }
                case '(': {
                    ParseResult res;
                    int end = ExprParser.next(pattern, ')', '(', j + 1);
                    String[] gs = pattern.substring(j + 1, end).split("\\|");
                    int j2 = j + 1;
                    int k = 0;
                    while (k < gs.length) {
                        res = this.parse_i(pattern, i, j2);
                        if (res != null) {
                            return res;
                        }
                        j2 += gs[k].length() + 1;
                        ++k;
                    }
                    return null;
                }
                case '%': {
                    int i2;
                    ParseResult res;
                    if (i == this.expr.length()) {
                        return null;
                    }
                    int end = ExprParser.next(pattern, '%', j + 1);
                    if (end == -1) {
                        throw new MalformedPatternException(pattern, "odd number of '%'");
                    }
                    String name = pattern.substring(j + 1, end);
                    if (name.startsWith("-")) {
                        name = name.substring(1);
                    }
                    Pair<String, Boolean> p = Utils.getPlural(name);
                    name = (String)p.first;
                    Class<?> returnType = Skript.getClass(name);
                    if (end == pattern.length() - 1) {
                        i2 = this.expr.length();
                    } else if (this.expr.charAt(i) == '\"') {
                        i2 = ExprParser.nextQuote(this.expr, i + 1) + 1;
                        if (i2 == 0) {
                            return null;
                        }
                    } else {
                        i2 = i + 1;
                    }
                    while (i2 <= this.expr.length()) {
                        if (i2 < this.expr.length() && this.expr.charAt(i2) == '\"' && (i2 = ExprParser.nextQuote(this.expr, i2 + 1) + 1) == 0) {
                            return null;
                        }
                        res = this.parse_i(pattern, i2, end + 1);
                        if (res != null) {
                            Variable<?> var = this.parseVar(returnType, this.expr.substring(i, i2), this.parseStatic);
                            if (var != null) {
                                if (!((Boolean)p.second).booleanValue() && !var.isSingle()) {
                                    throw new ParseException("this expression can only accept a single " + Skript.getExactClassName(returnType) + ", but multiple are given.");
                                }
                                res.vars[StringUtils.count((String)pattern, (char)'%', (int)0, (int)(j - 1)) / 2] = var;
                                return res;
                            }
                            if (this.bestErrorQuality < 80 && res.matchedChars > 5) {
                                this.bestError = "'" + this.expr.substring(i, i2) + "' is not " + Utils.a(Skript.getExactClassName(returnType));
                                this.bestErrorQuality = 80;
                            }
                        }
                        ++i2;
                    }
                    return null;
                }
                case '<': {
                    ParseResult res;
                    int end = pattern.indexOf(62, j + 1);
                    if (end == -1) {
                        throw new MalformedPatternException(pattern, "missing closing regex bracket '>'");
                    }
                    int i2 = i + 1;
                    while (i2 <= this.expr.length()) {
                        Matcher m;
                        res = this.parse_i(pattern, i2, end + 1);
                        if (res != null && (m = Pattern.compile(pattern.substring(j + 1, end)).matcher(this.expr.substring(i, i2))).matches()) {
                            res.regexes.add(0, m.toMatchResult());
                            return res;
                        }
                        ++i2;
                    }
                    return null;
                }
                case ')': 
                case ']': {
                    ++j;
                    break;
                }
                case '|': {
                    j = ExprParser.next(pattern, ')', '(', j + 1) + 1;
                    break;
                }
                case ' ': {
                    if (i == this.expr.length()) {
                        ++j;
                        break;
                    }
                    if (this.expr.charAt(i) != ' ') {
                        return null;
                    }
                    ++matchedChars;
                    ++i;
                    ++j;
                    break;
                }
                case '\\': {
                    if (++j == pattern.length()) {
                        throw new MalformedPatternException(pattern, "must not end with a backslash");
                    }
                }
                default: {
                    if (i == this.expr.length() || Character.toLowerCase(pattern.charAt(j)) != Character.toLowerCase(this.expr.charAt(i))) {
                        return null;
                    }
                    ++matchedChars;
                    ++i;
                    ++j;
                }
            }
        }
        if (i == this.expr.length() && j == pattern.length()) {
            return new ParseResult(this.expr, pattern, matchedChars);
        }
        return null;
    }

    private static final UnparsedLiteral parseUnparsedLiteral(String s) {
        ArrayList<String> parts = new ArrayList<String>();
        Pattern p = Pattern.compile("^([^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?)(,\\s*|,?\\s+and\\s+|,?\\s+n?or\\s+)");
        Matcher m = p.matcher(s);
        int prevEnd = 0;
        boolean and = true;
        boolean isAndSet = false;
        while (m.find()) {
            if (!m.group(2).matches(",\\s*")) {
                if (isAndSet) {
                    Skript.warning("list has multiple 'and' or 'or', will default to 'and': " + s);
                    and = true;
                } else {
                    and = m.group(2).contains("and");
                    isAndSet = true;
                }
            }
            parts.add(m.group(1).trim());
            prevEnd = m.end();
            m.region(m.end(), s.length());
        }
        if (!isAndSet && !parts.isEmpty()) {
            Skript.warning("list is missing 'and' or 'or', will default to 'and': " + s);
        }
        parts.add(s.substring(prevEnd).trim());
        return new UnparsedLiteral(parts.toArray(new String[0]), and);
    }

    private static final class MalformedPatternException
    extends RuntimeException {
        private static final long serialVersionUID = -2479399963189481643L;

        public MalformedPatternException(String pattern, String message) {
            super("\"" + pattern + "\": " + message);
        }
    }

    public static final class ParseResult {
        public final Variable<?>[] vars;
        public final List<MatchResult> regexes = new ArrayList<MatchResult>();
        public final String expr;
        int matchedChars = 0;

        public ParseResult(String expr, String pattern, int matchedChars) {
            this.expr = expr;
            this.vars = new Variable[StringUtils.count(pattern, '%') / 2];
            this.matchedChars = matchedChars;
        }
    }
}

