/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.exception.InitException;
import ch.njol.skript.api.exception.ParseException;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import org.bukkit.event.Event;

public class EffSet
extends Effect {
    private Variable<?> setter;
    private Variable<?> setted;

    static {
        Skript.registerEffect(EffSet.class, "set %objects% to %objects%");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) throws ParseException, InitException {
        this.setted = vars[0];
        this.setter = vars[1];
        if (this.setted instanceof UnparsedLiteral) {
            throw new InitException();
        }
        Class<?> r = this.setted.acceptChange(Changer.ChangeMode.SET);
        if (r == null) {
            throw new ParseException(this.setted + " can't be set");
        }
        boolean single = true;
        if (r.isArray()) {
            single = false;
            r = r.getComponentType();
        }
        if (!r.isAssignableFrom(this.setter.getReturnType())) {
            Variable<?> v = this.setter.getConvertedVariable(r);
            if (v == null) {
                throw new ParseException(this.setted + " can't be set to " + this.setter);
            }
            this.setter = v;
        }
        if (!this.setter.isSingle() && single) {
            throw new ParseException(this.setted + " can only be set to one " + Skript.getExactClassName(r) + ", but multiple are given");
        }
    }

    @Override
    protected void execute(Event e) {
        this.setted.change(e, this.setter, Changer.ChangeMode.SET);
    }

    @Override
    public String getDebugMessage(Event e) {
        return "set " + this.setted.getDebugMessage(null) + " to " + this.setter.getDebugMessage(e);
    }
}

