/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.Testable;
import ch.njol.skript.api.exception.InitException;
import ch.njol.skript.api.exception.ParseException;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import org.bukkit.event.Event;

public class EffRemove
extends Effect
implements Testable {
    private Variable<?> removed;
    private Variable<?> remover;

    static {
        Skript.registerEffect(EffRemove.class, "remove %objects% from %objects%");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) throws ParseException, InitException {
        this.remover = vars[0];
        this.removed = vars[1];
        if (this.removed instanceof UnparsedLiteral) {
            throw new InitException();
        }
        Class<?> r = this.removed.acceptChange(Changer.ChangeMode.REMOVE);
        if (r == null) {
            throw new ParseException(this.removed + " can't have something 'removed' from it");
        }
        boolean single = true;
        if (r.isArray()) {
            single = false;
            r = r.getComponentType();
        }
        if (!r.isAssignableFrom(this.remover.getReturnType())) {
            Variable<?> v = this.remover.getConvertedVariable(r);
            if (v == null) {
                throw new ParseException(this.remover + " can't be removed from " + this.removed);
            }
            this.remover = v;
        }
        if (!this.remover.isSingle() && single) {
            throw new ParseException("only one " + Skript.getExactClassName(r) + " can be removed from " + this.removed + ", but multiple are given");
        }
    }

    @Override
    protected void execute(Event e) {
        this.removed.change(e, this.remover, Changer.ChangeMode.REMOVE);
    }

    @Override
    public String getDebugMessage(Event e) {
        return "remove " + this.remover.getDebugMessage(e) + " from " + this.removed.getDebugMessage(null);
    }

    @Override
    public boolean test(Event e) {
        return false;
    }
}

