/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Slot;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class EffHealth
extends Effect {
    private Variable<Object> damageables;
    private Variable<Integer> damage;
    private boolean heal = false;

    static {
        Skript.registerEffect(EffHealth.class, "damage %slots% by %integer%", "damage %livingentities% by %integer%", "heal %livingentities% [by %-integer%]", "repair %slots% [by %-integer%]");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.damageables = vars[0];
        this.damage = vars[1];
        this.heal = matchedPattern >= 2;
    }

    @Override
    public void execute(Event e) {
        int damage = 0;
        if (this.damage != null) {
            damage = this.damage.getSingle(e);
        }
        Object[] objectArray = this.damageables.getArray(e);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object damageable = objectArray[n2];
            if (damageable instanceof Slot) {
                ItemStack is = ((Slot)damageable).getItem();
                if (this.damage == null) {
                    is.setDurability((short)0);
                } else {
                    is.setDurability((short)(is.getDurability() + (this.heal ? -damage : damage)));
                    if (is.getDurability() >= is.getType().getMaxDurability()) {
                        is = null;
                    }
                }
                ((Slot)damageable).setItem(is);
            } else if (damageable instanceof LivingEntity) {
                if (this.damage == null) {
                    ((LivingEntity)damageable).setHealth(((LivingEntity)damageable).getMaxHealth());
                } else {
                    ((LivingEntity)damageable).setHealth(((LivingEntity)damageable).getHealth() + (this.heal ? damage : -damage));
                }
            }
            ++n2;
        }
    }

    @Override
    public String getDebugMessage(Event e) {
        return String.valueOf(this.heal ? "heal " : "damage ") + this.damageables.getDebugMessage(e) + (this.damage == null ? "" : " by " + this.damage.getDebugMessage(e));
    }
}

