/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Offset;
import org.bukkit.Location;
import org.bukkit.event.Event;

public class EffExplosion
extends Effect {
    private Variable<Float> force;
    private Variable<Offset> offsets;
    private Variable<Location> locations;

    static {
        Skript.registerEffect(EffExplosion.class, "[create] explosion (of|with) (force|strength|power) %float% [%offsets% %locations%]");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.force = vars[0];
        this.offsets = vars[1];
        this.locations = vars[2];
    }

    @Override
    public void execute(Event e) {
        float power = this.force.getSingle(e).floatValue();
        Location[] locationArray = Offset.setOff(this.offsets.getArray(e), this.locations.getArray(e));
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location l = locationArray[n2];
            l.getWorld().createExplosion(l, power);
            ++n2;
        }
    }

    @Override
    public String getDebugMessage(Event e) {
        return "create explosion of force " + this.force.getDebugMessage(e) + " " + this.offsets.getDebugMessage(e) + " " + this.locations.getDebugMessage(e);
    }
}

