/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Offset;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class EffDrop
extends Effect {
    private Variable<ItemType> items;
    private Variable<Offset> offsets;
    private Variable<Location> locations;
    private boolean hasLoc = false;

    static {
        Skript.registerEffect(EffDrop.class, "drop %itemtypes% [%offsets% %-locations%]");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.items = vars[0];
        this.offsets = vars[1];
        this.locations = vars[2];
        boolean bl = this.hasLoc = this.locations != null;
        if (!this.hasLoc) {
            this.locations = Skript.getDefaultVariable(Location.class);
        }
    }

    @Override
    public void execute(Event e) {
        if (!this.hasLoc && e instanceof EntityDeathEvent) {
            ItemType[] itemTypeArray = this.items.getArray(e);
            int n = itemTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemType type = itemTypeArray[n2];
                type.addTo(((EntityDeathEvent)e).getDrops());
                ++n2;
            }
            return;
        }
        Location[] locationArray = Offset.setOff(this.offsets.getArray(e), this.locations.getArray(e));
        int n = locationArray.length;
        int n3 = 0;
        while (n3 < n) {
            Location l = locationArray[n3];
            ItemType[] itemTypeArray = this.items.getArray(e);
            int n4 = itemTypeArray.length;
            int n5 = 0;
            while (n5 < n4) {
                ItemType type = itemTypeArray[n5];
                for (ItemStack is : type.getItem().getAll()) {
                    l.getWorld().dropItemNaturally(l, is);
                }
                ++n5;
            }
            ++n3;
        }
    }

    @Override
    public String getDebugMessage(Event e) {
        return "drop " + this.items.getDebugMessage(e) + (this.hasLoc ? String.valueOf(this.offsets.getDebugMessage(e)) + " " + this.locations.getDebugMessage(e) : "");
    }
}

