/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.data;

import ch.njol.skript.Aliases;
import ch.njol.skript.Skript;
import ch.njol.skript.api.ClassInfo;
import ch.njol.skript.api.Parser;
import ch.njol.skript.api.exception.ParseException;
import ch.njol.skript.lang.SimpleLiteral;
import ch.njol.skript.util.EntityType;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Offset;
import ch.njol.skript.util.Slot;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timeperiod;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.VariableString;
import ch.njol.skript.util.WeatherType;
import ch.njol.skript.variables.base.EventValueVariable;
import org.bukkit.entity.Entity;

public class SkriptClasses {
    static {
        Skript.registerClass(new ClassInfo<WeatherType>("weather type", "weathertype", WeatherType.class, new SimpleLiteral<WeatherType>(WeatherType.CLEAR), new Parser<WeatherType>(){

            @Override
            public WeatherType parse(String s) {
                return WeatherType.parse(s);
            }

            @Override
            public String toString(WeatherType o) {
                return o.toString();
            }
        }, "weather ?types?", "weather conditions", "weathers?"));
        Skript.registerClass(new ClassInfo<EntityType>("entity type", "entitytype", EntityType.class, new SimpleLiteral<EntityType>(new EntityType(Entity.class, 1)), new Parser<EntityType>(){

            @Override
            public EntityType parse(String s) {
                return EntityType.parse(s);
            }

            @Override
            public String toString(EntityType t) {
                return t.toString();
            }
        }, "entity ?types?", "enit(y|ies)"));
        Skript.registerClass(new ClassInfo<VariableString>("variablestring", VariableString.class, null, new Parser<VariableString>(){

            @Override
            public VariableString parse(String s) {
                if (!s.startsWith("\"") || !s.endsWith("\"")) {
                    return null;
                }
                if (!s.matches("\"[^\"]*?(?:\"\"[^\"]*)*?\"")) {
                    Skript.error("Invalid use of quotes (\"). If you want to use quotes in \"quoted text\", double them: \"\".");
                    return null;
                }
                try {
                    return new VariableString(s.substring(1, s.length() - 1).replace("\"\"", "\""));
                }
                catch (ParseException e) {
                    return null;
                }
            }

            @Override
            public String toString(VariableString vs) {
                return vs.getDebugMessage(null);
            }
        }));
        Skript.registerClass(new ClassInfo<ItemType>("item type", "itemtype", ItemType.class, null, new Parser<ItemType>(){

            @Override
            public ItemType parse(String s) {
                return Aliases.parseItemType(s);
            }

            @Override
            public String toString(ItemType t) {
                return t.toString();
            }

            @Override
            public String getDebugMessage(ItemType t) {
                return t.getDebugMessage();
            }
        }, "item ?type", "items", "materials"));
        Skript.registerClass(new ClassInfo<Time>("time", "time", Time.class, new EventValueVariable<Time>(Time.class), new Parser<Time>(){

            @Override
            public Time parse(String s) {
                return Time.parse(s);
            }

            @Override
            public String toString(Time t) {
                return t.toString();
            }
        }, "times?"));
        new Timespan();
        Skript.registerClass(new ClassInfo<Timeperiod>("time period", "timeperiod", Timeperiod.class, new SimpleLiteral<Timeperiod>(new Timeperiod(0, 23999)), new Parser<Timeperiod>(){

            @Override
            public Timeperiod parse(String s) {
                if (s.equalsIgnoreCase("day")) {
                    return new Timeperiod(0, 11999);
                }
                if (s.equalsIgnoreCase("dusk")) {
                    return new Timeperiod(12000, 13799);
                }
                if (s.equalsIgnoreCase("night")) {
                    return new Timeperiod(13800, 22199);
                }
                if (s.equalsIgnoreCase("dawn")) {
                    return new Timeperiod(22200, 23999);
                }
                int c = s.indexOf(45);
                if (c == -1) {
                    Time t = Time.parse(s);
                    if (t == null) {
                        return null;
                    }
                    return new Timeperiod(t.getTicks());
                }
                Time t1 = Time.parse(s.substring(0, c).trim());
                Time t2 = Time.parse(s.substring(c + 1).trim());
                if (t1 == null || t2 == null) {
                    return null;
                }
                return new Timeperiod(t1.getTicks(), t2.getTicks());
            }

            @Override
            public String toString(Timeperiod o) {
                return o.toString();
            }
        }, "time ?periods?", "durations?"));
        Skript.registerClass(new ClassInfo<Offset>("offset", "offset", Offset.class, new SimpleLiteral<Offset>(new Offset(0.0, 0.0, 0.0)), new Parser<Offset>(){

            @Override
            public Offset parse(String s) {
                return Offset.parse(s);
            }

            @Override
            public String toString(Offset o) {
                return o.toString();
            }
        }, "offset"));
        Skript.registerClass(new ClassInfo<Slot>("slot", Slot.class, new EventValueVariable<Slot>(Slot.class), null));
    }
}

