/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.data;

import ch.njol.skript.api.Changer;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Slot;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timespan;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class DefaultChangers {
    public static final Changer<Block> blockChanger = new Changer<Block>(){

        @Override
        public Class<?> acceptChange(Changer.ChangeMode mode) {
            return ItemType[].class;
        }

        @Override
        public void change(Event e, Variable<Block> blocks, Variable<?> delta, Changer.ChangeMode mode) {
            Block[] blockArray = blocks.getArray(e);
            int n = blockArray.length;
            int n2 = 0;
            while (n2 < n) {
                Block block = blockArray[n2];
                switch (mode) {
                    case SET: {
                        ((ItemType)delta.getSingle(e)).setBlock(block, true);
                        break;
                    }
                    case CLEAR: {
                        block.setTypeId(0, true);
                        break;
                    }
                    case ADD: 
                    case REMOVE: {
                        ItemType type;
                        int n3;
                        int n4;
                        ItemType[] itemTypeArray;
                        BlockState state = block.getState();
                        if (!(state instanceof InventoryHolder)) break;
                        if (mode == Changer.ChangeMode.ADD) {
                            itemTypeArray = (ItemType[])delta.getArray(e);
                            n4 = itemTypeArray.length;
                            n3 = 0;
                            while (n3 < n4) {
                                type = itemTypeArray[n3];
                                type.addTo(((InventoryHolder)state).getInventory());
                                ++n3;
                            }
                        } else {
                            itemTypeArray = (ItemType[])delta.getArray(e);
                            n4 = itemTypeArray.length;
                            n3 = 0;
                            while (n3 < n4) {
                                type = itemTypeArray[n3];
                                type.removeFrom(((InventoryHolder)state).getInventory());
                                ++n3;
                            }
                        }
                        state.update();
                    }
                }
                ++n2;
            }
        }
    };
    public static final Changer<Inventory> inventoryChanger = new Changer<Inventory>(){

        @Override
        public Class<?> acceptChange(Changer.ChangeMode mode) {
            return ItemType[].class;
        }

        @Override
        public void change(Event e, Variable<Inventory> invis, Variable<?> delta, Changer.ChangeMode mode) {
            Inventory[] inventoryArray = invis.getArray(e);
            int n = inventoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Inventory invi = inventoryArray[n2];
                switch (mode) {
                    case SET: 
                    case CLEAR: {
                        invi.clear();
                        if (invi instanceof PlayerInventory) {
                            ((PlayerInventory)invi).setArmorContents(new ItemStack[4]);
                        }
                        if (mode == Changer.ChangeMode.CLEAR) break;
                    }
                    case ADD: {
                        ItemType type;
                        ItemType[] itemTypeArray = (ItemType[])delta.getArray(e);
                        int n3 = itemTypeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            type = itemTypeArray[n4];
                            type.addTo(invi);
                            ++n4;
                        }
                        break;
                    }
                    case REMOVE: {
                        ItemType type;
                        ItemType[] itemTypeArray = (ItemType[])delta.getArray(e);
                        int n3 = itemTypeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            type = itemTypeArray[n4];
                            type.removeFrom(invi);
                            ++n4;
                        }
                        break;
                    }
                }
                if (invi instanceof PlayerInventory) {
                    ((Player)invi.getHolder()).updateInventory();
                }
                ++n2;
            }
        }
    };
    public static final Changer<Slot> slotChanger = new Changer<Slot>(){

        @Override
        public Class<?> acceptChange(Changer.ChangeMode mode) {
            return ItemType.class;
        }

        @Override
        public void change(Event e, Variable<Slot> slots, Variable<?> delta, Changer.ChangeMode mode) {
            ItemType type = (ItemType)delta.getSingle(e);
            if (type == null && mode != Changer.ChangeMode.CLEAR) {
                return;
            }
            Slot[] slotArray = slots.getArray(e);
            int n = slotArray.length;
            int n2 = 0;
            while (n2 < n) {
                Slot slot = slotArray[n2];
                switch (mode) {
                    case SET: {
                        slot.setItem(type.getItem().getRandom());
                        break;
                    }
                    case ADD: {
                        slot.setItem(type.getItem().addTo(slot.getItem()));
                        break;
                    }
                    case REMOVE: {
                        slot.setItem(type.removeFrom(slot.getItem()));
                        break;
                    }
                    case CLEAR: {
                        slot.setItem(null);
                    }
                }
                ++n2;
            }
        }
    };
    public static final Changer<World> timeChanger = new Changer<World>(){

        @Override
        public Class<?> acceptChange(Changer.ChangeMode mode) {
            switch (mode) {
                case ADD: 
                case REMOVE: {
                    return Timespan.class;
                }
                case SET: {
                    return Time.class;
                }
            }
            return null;
        }

        @Override
        public void change(Event e, Variable<World> worlds, Variable<?> delta, Changer.ChangeMode mode) {
            int mod = 1;
            switch (mode) {
                case SET: {
                    Time time = (Time)delta.getSingle(e);
                    World[] worldArray = worlds.getArray(e);
                    int n = worldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        World w = worldArray[n2];
                        w.setTime((long)time.getTicks());
                        ++n2;
                    }
                    break;
                }
                case REMOVE: {
                    mod = -1;
                }
                case ADD: {
                    Timespan ts = (Timespan)delta.getSingle(e);
                    World[] worldArray = worlds.getArray(e);
                    int n = worldArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        World w = worldArray[n3];
                        w.setTime((long)((float)w.getTime() + (float)mod * ts.getTicks()));
                        ++n3;
                    }
                    break;
                }
            }
        }
    };
}

