/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.config;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptLogger;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.ConfigReader;
import ch.njol.skript.config.ParseOptionNode;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.VoidNode;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Node {
    protected String name;
    protected final int lineNum;
    protected String orig;
    protected boolean modified = false;
    protected SectionNode parent;
    protected final Config config;

    protected Node(Config config, String name, String orig, int lineNum) {
        this.config = config;
        this.orig = orig;
        this.name = name;
        this.lineNum = lineNum;
        SkriptLogger.setNode(this);
    }

    protected Node(String name, SectionNode parent, ConfigReader r) {
        this.name = name;
        this.orig = r.getLine();
        this.lineNum = r.getLineNum();
        this.config = parent.getConfig();
        this.parent = parent;
        SkriptLogger.setNode(this);
    }

    protected Node(Config c) {
        this.name = null;
        this.orig = null;
        this.lineNum = -1;
        this.config = c;
        this.parent = null;
        SkriptLogger.setNode(this);
    }

    public String getName() {
        return this.name;
    }

    public Config getConfig() {
        return this.config;
    }

    public void rename(String newname) {
        if (this.name == null) {
            Skript.error("can't rename an anonymous node!");
            return;
        }
        this.name = newname;
        this.modified();
    }

    public void move(SectionNode newParent) {
        if (this.parent == null) {
            Skript.error("can't move the main node!");
            return;
        }
        this.parent.getNodeList().remove(this);
        this.parent = newParent;
        newParent.getNodeList().add(this);
        this.config.modified = true;
    }

    protected void modified() {
        this.modified = true;
        this.config.modified = true;
    }

    protected String getComment() {
        Matcher m = Pattern.compile("\\s*(?<!#)#[^#].*$").matcher(this.getOrig());
        if (!m.find()) {
            return "";
        }
        return m.group();
    }

    protected String getIndentation() {
        String s = "";
        Node n = this;
        while ((n = n.parent) != null) {
            s = String.valueOf(s) + this.config.getIndentation();
        }
        return s;
    }

    abstract void save(PrintWriter var1);

    public SectionNode getParent() {
        return this.parent;
    }

    public void move(int index) {
        this.parent.getNodeList().remove(this);
        this.parent.getNodeList().add(index, this);
        this.config.modified = true;
    }

    public void moveDelta(int deltaIndex) {
        this.move(this.parent.getNodeList().indexOf(this) + deltaIndex);
    }

    public void delete() {
        this.parent.getNodeList().remove(this);
        this.config.modified = true;
    }

    public String getOrig() {
        return this.orig;
    }

    public int getLine() {
        return this.lineNum;
    }

    public boolean isVoid() {
        return this instanceof VoidNode || this instanceof ParseOptionNode;
    }

    public Node getNode(String path) {
        return this.getNode(path, false);
    }

    public Node getNode(String path, boolean create) {
        Node n;
        if (path.startsWith(":")) {
            path = path.substring(1);
            n = this;
        } else {
            n = this.config.getMainNode();
        }
        String[] stringArray = path.split(":");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String s = stringArray[n3];
            if (s.isEmpty()) {
                if ((n = n.getParent()) == null) {
                    n = this.config.getMainNode();
                }
            } else {
                if (!(n instanceof SectionNode)) {
                    return null;
                }
                if (s.startsWith("#")) {
                    int i = -1;
                    try {
                        i = Integer.parseInt(s.substring(1));
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                    if (i <= 0 || i > ((SectionNode)n).getNodeList().size()) {
                        return null;
                    }
                    n = ((SectionNode)n).getNodeList().get(i - 1);
                } else {
                    Node oldn = n;
                    if ((n = ((SectionNode)n).get(s)) == null) {
                        if (!create) {
                            return null;
                        }
                        n = new SectionNode(s, (SectionNode)oldn, "", -1);
                        ((SectionNode)oldn).getNodeList().add(n);
                    }
                }
            }
            ++n3;
        }
        return n;
    }

    public String toString() {
        return String.valueOf(this.getOrig().trim()) + " (" + this.getConfig().getFileName() + ", line " + this.getLine() + ")";
    }
}

