/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.config;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptLogger;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.InvalidNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.ParseOptionNode;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.SimpleNode;
import ch.njol.skript.config.VoidNode;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ConfigNode {
    protected String name;
    protected final int lineNum;
    protected String orig;
    protected boolean modified = false;
    protected SectionNode parent;
    protected final Config config;

    protected ConfigNode(Config config, String name, String orig, int lineNum) {
        this.config = config;
        this.orig = orig;
        this.name = name;
        this.lineNum = lineNum;
    }

    protected ConfigNode(String name, SectionNode parent) {
        this.name = name;
        this.orig = parent.getConfig().r.getLine();
        this.lineNum = parent.getConfig().r.getLineNum();
        this.config = parent.getConfig();
        this.parent = parent;
        SkriptLogger.setNode((ConfigNode)this);
    }

    protected ConfigNode(Config c) {
        this.name = null;
        this.orig = null;
        this.lineNum = -1;
        this.config = c;
        this.parent = null;
        SkriptLogger.setNode((ConfigNode)this);
    }

    void setIndentation(String option) {
        if (option.equals("tab") || option.equals("tabs")) {
            this.config.indentation = "\t";
            this.config.indentationName = "tab";
        } else if (option.equals("spaces")) {
            this.config.indentation = "    ";
            this.config.indentationName = "4 spaces";
        } else if (option.equals("space")) {
            this.config.indentation = " ";
            this.config.indentationName = option;
        } else if (option.matches("[1-9] spaces")) {
            int i = Integer.parseInt(option.substring(0, option.indexOf(32)));
            this.config.indentationName = option;
            this.config.indentation = " ";
            int j = 1;
            while (j < i) {
                this.config.indentation = String.valueOf(this.config.indentation) + " ";
                ++j;
            }
        } else {
            Skript.error("unknown indentation type");
        }
    }

    public String getName() {
        return this.name;
    }

    public Config getConfig() {
        return this.config;
    }

    public void rename(String newname) {
        if (this.name == null) {
            Skript.error("can't rename an anonymous node!");
            return;
        }
        this.name = newname;
        this.modified();
    }

    public void move(SectionNode newParent) {
        if (this.parent == null) {
            Skript.error("can't move the main node!");
            return;
        }
        if (!newParent.isSection()) {
            Skript.error("non-section nodes can't have subnodes / a section node has to end with a colon (:)");
            return;
        }
        this.parent.getNodeList().remove(this);
        this.parent = newParent;
        newParent.getNodeList().add((Node)this);
        this.config.modified = true;
    }

    protected void modified() {
        this.modified = true;
        this.config.modified = true;
    }

    protected String getComment() {
        Matcher m = Pattern.compile("\\s*(?<!#)#[^#].*$").matcher(this.getOrig());
        if (!m.find()) {
            return "";
        }
        return m.group();
    }

    protected String getIndentation() {
        String s = "";
        Object n = this;
        while ((n = n.parent) != null) {
            s = String.valueOf(s) + this.config.indentation;
        }
        return s;
    }

    abstract void save(PrintWriter var1);

    public SectionNode getParent() {
        return this.parent;
    }

    public void move(int index) {
        this.parent.getNodeList().remove(this);
        this.parent.getNodeList().add(index, (Node)this);
        this.config.modified = true;
    }

    public void moveDelta(int deltaIndex) {
        this.move(this.parent.getNodeList().indexOf(this) + deltaIndex);
    }

    public boolean setValue(String v) {
        return false;
    }

    public void delete() {
        this.parent.getNodeList().remove(this);
        this.config.modified = true;
    }

    public String getOrig() {
        return this.orig;
    }

    public boolean isSection() {
        return this instanceof SectionNode;
    }

    public boolean isVoid() {
        return this instanceof VoidNode || this.isParseOption();
    }

    public boolean isInvalid() {
        return this instanceof InvalidNode;
    }

    public boolean isEntry() {
        return this instanceof EntryNode || this instanceof SimpleNode;
    }

    private boolean isParseOption() {
        return this instanceof ParseOptionNode;
    }

    public int getLine() {
        return this.lineNum;
    }

    public ConfigNode getNode(String path) {
        return this.getNode(path, false);
    }

    public ConfigNode getNode(String path, boolean create) {
        SectionNode n;
        if (path.startsWith(":")) {
            path = path.substring(1);
            n = this;
        } else {
            n = this.config.getMainNode();
        }
        String[] stringArray = path.split(":");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String s = stringArray[n3];
            if (s.isEmpty()) {
                if ((n = n.getParent()) == null) {
                    n = this.config.getMainNode();
                }
            } else {
                if (!n.isSection()) {
                    return null;
                }
                if (s.startsWith("#")) {
                    int i = -1;
                    try {
                        i = Integer.parseInt(s.substring(1));
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                    if (i <= 0 || i > n.getNodeList().size()) {
                        return null;
                    }
                    n = (ConfigNode)n.getNodeList().get(i - 1);
                } else {
                    SectionNode oldn = n;
                    if ((n = n.get(s)) == null) {
                        if (!create) {
                            return null;
                        }
                        n = new SectionNode(s, oldn);
                        oldn.getNodeList().add(n);
                    }
                }
            }
            ++n3;
        }
        return n;
    }
}

