/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Condition;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.VariableString;
import ch.njol.util.Checker;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;

public class CondPermission
extends Condition {
    private Variable<VariableString> permissions;
    private Variable<CommandSender> senders;

    static {
        Skript.registerCondition(CondPermission.class, "[%commandsenders%] (do[es]n't|don't|do[es] not) have [the] permission[s] %variablestrings%", "[%commandsenders%] ha(s|ve) [the] permission[s] %variablestrings%");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.senders = vars[0];
        this.permissions = vars[1];
        this.setNegated(matchedPattern == 0);
    }

    @Override
    public boolean run(Event e) {
        return this.senders.check(e, new Checker<CommandSender>(){

            @Override
            public boolean check(final CommandSender s) {
                return CondPermission.this.permissions.check(e, new Checker<VariableString>(){

                    @Override
                    public boolean check(VariableString perm) {
                        String p = perm.get(e);
                        if (s.hasPermission(p)) {
                            return true;
                        }
                        if (p.startsWith("skript.")) {
                            int i = p.lastIndexOf(46);
                            while (i > 0) {
                                if (s.hasPermission(String.valueOf(p.substring(0, i + 1)) + "*")) {
                                    return true;
                                }
                                i = p.lastIndexOf(46, i - 1);
                            }
                        }
                        return false;
                    }
                });
            }
        }, this);
    }

    @Override
    public String getDebugMessage(Event e) {
        return String.valueOf(this.senders.getDebugMessage(e)) + " " + (this.isNegated() ? "doesn't have" : "has") + " permission " + this.permissions.getDebugMessage(e);
    }
}

