/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Condition;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CondItemInHand
extends Condition {
    private Variable<Player> players;
    private Variable<ItemType> types;

    static {
        Skript.registerCondition(CondItemInHand.class, "[%players%] ha(s|ve) %itemtypes% in hand", "[%players%] (is|are) holding %itemtypes%", "[%players%] (ha(s|ve) not|do[es]n't have) %itemtypes% in hand", "[%players%] (is not|isn't) holding %itemtypes%");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.players = vars[0];
        this.types = vars[1];
        this.setNegated(matchedPattern >= 2);
    }

    @Override
    public boolean run(Event e) {
        return this.players.check(e, new Checker<Player>(){

            @Override
            public boolean check(final Player p) {
                return CondItemInHand.this.types.check(e, new Checker<ItemType>(){

                    @Override
                    public boolean check(ItemType type) {
                        return type.isOfType(p.getItemInHand());
                    }
                });
            }
        }, this);
    }

    @Override
    public String getDebugMessage(Event e) {
        return String.valueOf(this.players.getDebugMessage(e)) + " is holding " + this.types.getDebugMessage(e);
    }
}

