/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Condition;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CondInventoryContains
extends Condition {
    private Variable<Inventory> invis;
    private Variable<ItemType> items;

    static {
        Skript.registerCondition(CondInventoryContains.class, "[%inventories%] ha(s|ve) %itemtypes% [in inventory]", "[%inventories%] contain[s] %itemtypes%", "[%inventories%] (ha(s|ve) not|do[es]n't have) %itemtypes% [in inventory]", "[%inventories%] do[es](n't| not) contain %itemtypes%");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.invis = vars[0];
        this.items = vars[1];
        this.setNegated(matchedPattern >= 2);
    }

    @Override
    public boolean run(Event e) {
        return this.invis.check(e, new Checker<Inventory>(){

            @Override
            public boolean check(Inventory invi) {
                final ItemStack[] buf = invi.getContents();
                return CondInventoryContains.this.items.check(e, new Checker<ItemType>(){

                    @Override
                    public boolean check(ItemType type) {
                        return type.isContainedIn(buf);
                    }
                });
            }
        }, this);
    }

    @Override
    public String getDebugMessage(Event e) {
        return String.valueOf(this.invis.getDebugMessage(e)) + (this.isNegated() ? " doesn't have " : " has ") + this.items.getDebugMessage(e);
    }
}

