/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.Skript;
import ch.njol.skript.Verbosity;
import ch.njol.skript.api.SimpleEvent;
import ch.njol.skript.api.intern.Trigger;
import ch.njol.skript.api.intern.TriggerItem;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.SkriptCommandEvent;
import ch.njol.skript.util.Utils;
import ch.njol.util.Validate;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;

public class SkriptCommand
extends Command
implements PluginIdentifiableCommand {
    private final Trigger trigger;
    private final List<Argument<?>> arguments;

    public SkriptCommand(String name, List<Argument<?>> arguments, String description, String usageMessage, List<String> aliases, String permission, String permissionMessage, List<TriggerItem> items) {
        super(name, description, usageMessage, aliases);
        Validate.notNull(name, arguments, description, usageMessage, aliases, items);
        this.trigger = new Trigger("command /" + name, new SimpleEvent(), items);
        this.setPermission(permission);
        this.setPermissionMessage(permissionMessage == null ? "You don't have the required permission to use this command" : permissionMessage);
        this.arguments = arguments;
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return false;
        }
        if ((args = Utils.join(args, " ").trim().split("\\s*,\\s*")).length == 1 && args[0].isEmpty()) {
            args = new String[]{};
        }
        SkriptCommandEvent event = new SkriptCommandEvent(this, sender, args);
        int i = 0;
        while (i < this.arguments.size()) {
            Argument<?> a = this.arguments.get(i);
            if (i < args.length) {
                if (a.isSingle()) {
                    if (!a.parse(args[i], sender)) {
                        sender.sendMessage("correct usage: " + this.getUsage());
                        return false;
                    }
                } else if (!a.parse(args, i, sender)) {
                    sender.sendMessage("correct usage: " + this.getUsage());
                    return false;
                }
            } else {
                a.setToDefault(event);
            }
            ++i;
        }
        if (Skript.log(Verbosity.VERY_HIGH)) {
            Skript.info("# /" + this.getName() + " " + Utils.join(args, ", "));
        }
        long startTrigger = System.nanoTime();
        this.trigger.run(event);
        if (Skript.log(Verbosity.VERY_HIGH)) {
            Skript.info("# " + this.getName() + " took " + 1.0 * (double)(System.nanoTime() - startTrigger) / 1000000.0 + " milliseconds");
        }
        return true;
    }

    public List<Argument<?>> getArguments() {
        return this.arguments;
    }

    public Plugin getPlugin() {
        return Skript.getInstance();
    }
}

