/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Converter;
import ch.njol.skript.api.exception.ParseException;
import ch.njol.skript.command.SkriptCommandEvent;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.VariableString;
import java.lang.reflect.Array;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class Argument<T> {
    private final VariableString def;
    private final T defT;
    private final Class<T> type;
    private final Converter<String, ? extends T> conv;
    private final boolean single;
    private final int index;
    private T[] current;
    private final T[] singleTArray;

    public Argument(Class<T> type, String def, int index, boolean single) throws ParseException {
        this.type = type;
        this.singleTArray = (Object[])Array.newInstance(type, 1);
        this.conv = type != String.class ? Skript.getParser(type) : null;
        VariableString variableString = this.def = def == null ? null : new VariableString(def);
        if (def != null && this.def.isSimple()) {
            this.defT = type == String.class ? def : this.conv.convert(def);
            if (this.defT == null) {
                throw new ParseException("'" + def + "' is not " + Utils.a(Skript.getExactClassName(type)));
            }
        } else {
            this.defT = null;
        }
        this.single = single;
        this.index = index;
    }

    public static <T> Argument<T> newInstance(Class<T> type, String def, int index, boolean single) {
        try {
            return new Argument<T>(type, def, index, single);
        }
        catch (ParseException e) {
            Skript.error(e.getError());
            return null;
        }
    }

    public String toString() {
        return "<" + Skript.getExactClassName(this.type) + (this.single ? "" : "s") + (this.def == null ? "" : " = " + (this.defT != null ? Skript.toString(this.defT) : Skript.toString(this.def))) + ">";
    }

    public void setToDefault(SkriptCommandEvent event) {
        if (this.defT != null) {
            this.current = this.singleTArray;
            this.current[0] = this.defT;
            return;
        }
        this.parse(this.def.get(event), (CommandSender)Bukkit.getConsoleSender());
    }

    public boolean parse(String s, CommandSender sender) {
        this.current = this.singleTArray;
        if (this.type == String.class) {
            this.current[0] = s;
            return true;
        }
        this.current[0] = this.conv.convert(s);
        if (this.current[0] == null) {
            sender.sendMessage("'" + s + "' is not " + Utils.a(Skript.getExactClassName(this.type)));
        }
        return this.current[0] != null;
    }

    public boolean parse(String[] args, int start, CommandSender sender) {
        if (this.type == String.class) {
            this.current = this.singleTArray;
            StringBuilder b = new StringBuilder(args[start]);
            int i = start + 1;
            while (i < args.length) {
                b.append(", ").append(args[i]);
                ++i;
            }
            this.current[0] = b.toString();
            return true;
        }
        this.current = (Object[])Array.newInstance(this.type, args.length - start);
        int i = 0;
        while (i < args.length - start) {
            this.current[i] = this.conv.convert(args[start + i]);
            if (this.current[i] == null) {
                sender.sendMessage("'" + args[start + i] + "' is not " + Utils.a(Skript.getExactClassName(this.type)));
                return false;
            }
            ++i;
        }
        return true;
    }

    public T[] getCurrent() {
        return this.current;
    }

    public Class<T> getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isSingle() {
        return this.single;
    }
}

