/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.api.intern;

import ch.njol.skript.api.Condition;
import ch.njol.skript.api.Converter;
import ch.njol.skript.api.intern.ConvertedLiteral;
import ch.njol.skript.api.intern.SkriptAPIException;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.VariableString;
import ch.njol.util.Checker;
import java.lang.reflect.Array;
import org.bukkit.event.Event;

public class VariableStringLiteral
extends ConvertedLiteral<Object, String> {
    private final VariableString[] strings;
    private final String[] temp;

    public VariableStringLiteral(UnparsedLiteral source) {
        super(source, null, String.class);
        this.strings = VariableString.makeStringsFromQuoted(source.getData());
        this.temp = new String[this.strings.length];
    }

    public static VariableStringLiteral newInstance(UnparsedLiteral source) {
        String[] stringArray = source.getData();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!s.startsWith("\"") && !s.endsWith("\"")) {
                return null;
            }
            ++n2;
        }
        return new VariableStringLiteral(source);
    }

    @Override
    public String getDebugMessage(Event e) {
        return "[" + Utils.join(this.strings, e, this.getAnd()) + "]";
    }

    public String[] getArray() {
        int i = 0;
        while (i < this.strings.length) {
            if (!this.strings[i].isSimple()) {
                return null;
            }
            ++i;
        }
        return ((UnparsedLiteral)this.source).getData();
    }

    public String[] getArray(Event e) {
        int i = 0;
        while (i < this.strings.length) {
            this.temp[i] = this.strings[i].get(e);
            ++i;
        }
        return this.temp;
    }

    @Override
    public <V> V[] getArray(Event e, Class<V> to, Converter<? super String, ? extends V> converter) {
        Object[] vs = (Object[])Array.newInstance(to, this.strings.length);
        int i = 0;
        while (i < this.strings.length) {
            vs[i] = converter.convert(this.strings[i].get(e));
            ++i;
        }
        return vs;
    }

    @Override
    public String getSingle() {
        if (this.getAnd() && this.strings.length > 1) {
            throw new SkriptAPIException("Call to getSingle on a non-single variable");
        }
        return Utils.getRandom(((UnparsedLiteral)this.source).getData());
    }

    @Override
    public String getSingle(Event e) {
        if (this.getAnd() && this.strings.length > 1) {
            throw new SkriptAPIException("Call to getSingle on a non-single variable");
        }
        return Utils.getRandom(this.strings).get(e);
    }

    @Override
    public <V> V getSingle(Event e, Converter<? super String, ? extends V> converter) {
        return converter.convert(this.getSingle(e));
    }

    @Override
    public boolean check(Event e, Checker<? super String> c) {
        return SimpleVariable.check(this.getArray(e), c, false, this.getAnd());
    }

    @Override
    public boolean check(Event e, Checker<? super String> c, Condition cond) {
        return SimpleVariable.check(this.getArray(e), c, cond.isNegated(), this.getAnd());
    }

    @Override
    public String toString() {
        return "[" + Utils.join(this.strings, null, this.getAnd()) + "]";
    }

    @Override
    public Class<String> getReturnType() {
        return String.class;
    }
}

