/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.api;

import ch.njol.skript.api.DefaultVariable;
import ch.njol.skript.api.Parser;
import java.util.regex.Pattern;

public class ClassInfo<T> {
    private final Class<T> c;
    private final String name;
    private final String codeName;
    private final DefaultVariable<T> defaultVariable;
    private final Parser<T> parser;
    private final Pattern[] userInputPatterns;

    public ClassInfo(String name, String codeName, Class<T> c, DefaultVariable<T> defaultVariable, Parser<T> parser, String ... userInputPatterns) {
        this.c = c;
        this.name = name;
        this.codeName = codeName;
        this.defaultVariable = defaultVariable;
        this.parser = parser;
        this.userInputPatterns = new Pattern[userInputPatterns.length];
        int i = 0;
        while (i < userInputPatterns.length) {
            this.userInputPatterns[i] = Pattern.compile("^" + userInputPatterns[i] + "$");
            ++i;
        }
    }

    public ClassInfo(String codeName, Class<T> c, DefaultVariable<T> defaultVariable, Parser<T> parser) {
        this.c = c;
        this.name = codeName;
        this.codeName = codeName;
        this.defaultVariable = defaultVariable;
        this.parser = parser;
        this.userInputPatterns = new Pattern[0];
    }

    public Class<T> getC() {
        return this.c;
    }

    public String getName() {
        return this.name;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public DefaultVariable<T> getDefaultVariable() {
        return this.defaultVariable;
    }

    public Parser<T> getParser() {
        return this.parser;
    }

    public Pattern[] getUserInputPatterns() {
        return this.userInputPatterns;
    }
}

