/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Verbosity;
import ch.njol.skript.config.Node;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public abstract class SkriptLogger {
    private static Node node = null;
    private static String prefix = "";
    private static String oldPrefix = null;
    private static Verbosity verbosity = Verbosity.NORMAL;
    static boolean debug;

    static void setVerbosity(Verbosity v) {
        verbosity = v;
        if (v.compareTo(Verbosity.DEBUG) >= 0) {
            debug = true;
        }
    }

    public static void log(Level level, String message) {
        if (node != null && level.intValue() >= Level.WARNING.intValue()) {
            if (node.getParent() != null) {
                SkriptLogger.logDirect(level, String.valueOf(message) + " (" + node.getConfig().getFileName() + ", line " + node.getLine() + (node.getOrig() == null ? "" : ": '" + node.getOrig().trim() + "')"));
            } else {
                SkriptLogger.logDirect(level, String.valueOf(message) + " (" + node.getConfig().getFileName() + " [unknown line])");
            }
        } else {
            SkriptLogger.logDirect(level, message);
        }
    }

    public static void setNode(Node node) {
        SkriptLogger.node = node == null || node.getParent() == null ? null : node;
    }

    static Node getNode() {
        return node;
    }

    public static void logDirect(Level level, String message) {
        Bukkit.getLogger().log(level, "[Skript] " + prefix + message);
    }

    public static final String setPrefix(String prefix) {
        oldPrefix = SkriptLogger.prefix;
        SkriptLogger.prefix = prefix;
        return oldPrefix;
    }

    public static final void resetPrefix() throws IllegalStateException {
        if (oldPrefix == null) {
            throw new IllegalStateException("resetPrefix was called without a setPrefix beforehand");
        }
        prefix = oldPrefix;
        oldPrefix = null;
    }

    public static boolean log(Verbosity minVerb) {
        return minVerb.compareTo(verbosity) <= 0;
    }
}

