/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Aliases;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.SkriptLogger;
import ch.njol.skript.TriggerFileLoader;
import ch.njol.skript.Verbosity;
import ch.njol.skript.api.ClassInfo;
import ch.njol.skript.api.Comparator;
import ch.njol.skript.api.Condition;
import ch.njol.skript.api.Converter;
import ch.njol.skript.api.DefaultVariable;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.Getter;
import ch.njol.skript.api.InverseComparator;
import ch.njol.skript.api.LoopVar;
import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.api.intern.ChainedConverter;
import ch.njol.skript.api.intern.SkriptAPIException;
import ch.njol.skript.api.intern.TopLevelExpression;
import ch.njol.skript.api.intern.Trigger;
import ch.njol.skript.command.CommandEvent;
import ch.njol.skript.command.SkriptCommand;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.EnumEntryValidator;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.data.BukkitEventValues;
import ch.njol.skript.data.DefaultClasses;
import ch.njol.skript.data.DefaultComparators;
import ch.njol.skript.data.DefaultConverters;
import ch.njol.skript.data.SkriptClasses;
import ch.njol.skript.data.SkriptEventValues;
import ch.njol.skript.data.SkriptTriggerItems;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableInfo;
import ch.njol.skript.util.ErrorSession;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Utils;
import ch.njol.util.Setter;
import ch.njol.util.Validate;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Skript
extends JavaPlugin {
    private static Skript instance = null;
    public static final String TRIGGERFILEFOLDER = "triggers";
    public static final String quotesError = "Invalid use of quotes (\"). If you want to use quotes in \"quoted text\", double them: \"\".";
    public static final double EPSILON = 1.0E-20;
    public static final int MAXBLOCKID = 255;
    public static final int TARGETBLOCKMAXDISTANCE = 100;
    public static final int NUMBERACCURACY = 3;
    public static final Random random = new Random();
    private static EventPriority priority = EventPriority.NORMAL;
    static boolean listenerEnabled = true;
    private static boolean acceptRegistrations = true;
    static final Collection<ExpressionInfo<? extends Condition>> conditions = new ArrayList<ExpressionInfo<? extends Condition>>(20);
    static final Collection<ExpressionInfo<? extends Effect>> effects = new ArrayList<ExpressionInfo<? extends Effect>>(20);
    static final Collection<ExpressionInfo<? extends TopLevelExpression>> topLevelExpressions = new ArrayList<ExpressionInfo<? extends TopLevelExpression>>(40);
    static final Collection<VariableInfo<? extends Variable<?>, ?>> variables = new ArrayList(30);
    static final Collection<SkriptEvent.SkriptEventInfo<?>> events = new ArrayList(50);
    private static List<Converter.ConverterInfo<?, ?>> converters = new ArrayList(50);
    private static final List<ClassInfo<?>> classInfos = new ArrayList(50);
    private static final Collection<Comparator.ComparatorInfo<?, ?>> comparators = new ArrayList();
    private static final List<EventValueInfo<?, ?>> eventValues = new ArrayList(30);
    static final ArrayList<LoopVar.LoopInfo<?, ?>> loops = new ArrayList();
    private static final Set<SkriptCommand> commands = new HashSet<SkriptCommand>();
    public static CommandMap commandMap = null;
    private static final Deque<ErrorSession> errorSessionStack;
    private static ErrorSession errorSession;
    private static final String EXCEPTION_PREFIX = "##!! ";
    static Config mainConfig;
    static final ArrayList<Config> configs;
    private static boolean keepConfigsLoaded;
    private static boolean enableEffectCommands;

    static {
        try {
            if (Bukkit.getServer() instanceof CraftServer) {
                Field f = CraftServer.class.getDeclaredField("commandMap");
                f.setAccessible(true);
                commandMap = (CommandMap)f.get(Bukkit.getServer());
            }
        }
        catch (SecurityException e) {
            Skript.error("Please disable the security manager");
        }
        catch (Exception e) {
            Skript.outdatedError(e);
        }
        errorSessionStack = new LinkedList<ErrorSession>();
        errorSession = null;
        configs = new ArrayList();
        keepConfigsLoaded = true;
        enableEffectCommands = false;
    }

    public static Skript getInstance() {
        return instance;
    }

    public Skript() throws IllegalAccessException {
        if (instance != null) {
            throw new IllegalAccessException();
        }
        instance = this;
        new BukkitEventValues();
        new DefaultClasses();
        new DefaultComparators();
        new DefaultConverters();
        new SkriptClasses();
        new SkriptEventValues();
        new SkriptTriggerItems();
    }

    public void onEnable() {
        this.loadMainConfig();
        if (Skript.logNormal()) {
            Skript.info(" ~ created & \u00a9 by Peter G\u00fcttinger aka Njol ~");
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Skript.stopAcceptingRegistrations();
                Skript.loadTriggerFiles();
                Skript.info("Skript finished loading!");
            }
        });
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
    }

    public static <T> T[] array(T ... array) {
        return array;
    }

    public static void disableListener() {
        listenerEnabled = false;
    }

    public static void enableListener() {
        listenerEnabled = true;
    }

    private static void checkAcceptRegistrations() {
        if (!acceptRegistrations) {
            throw new SkriptAPIException("Registering is disabled after initialization!");
        }
    }

    private static void stopAcceptingRegistrations() {
        acceptRegistrations = false;
        Skript.createMissingConverters();
    }

    public static <E extends Condition> void registerCondition(Class<E> condition, String ... patterns) {
        Skript.checkAcceptRegistrations();
        ExpressionInfo<E> info = new ExpressionInfo<E>(patterns, condition);
        conditions.add(info);
        topLevelExpressions.add(info);
    }

    public static <E extends Effect> void registerEffect(Class<E> effect, String ... patterns) {
        Skript.checkAcceptRegistrations();
        ExpressionInfo<E> info = new ExpressionInfo<E>(patterns, effect);
        effects.add(info);
        topLevelExpressions.add(info);
    }

    public static Collection<ExpressionInfo<? extends TopLevelExpression>> getTopLevelExpressions() {
        return topLevelExpressions;
    }

    public static Collection<ExpressionInfo<? extends Condition>> getConditions() {
        return conditions;
    }

    public static Collection<ExpressionInfo<? extends Effect>> getEffects() {
        return effects;
    }

    public static <E extends SimpleVariable<T>, T> void registerVariable(Class<E> c, Class<T> returnType, String ... patterns) {
        Skript.checkAcceptRegistrations();
        variables.add(new VariableInfo<E, T>(patterns, returnType, c));
    }

    public static Collection<VariableInfo<? extends Variable<?>, ?>> getVariables() {
        return variables;
    }

    public static <E extends SkriptEvent> void registerEvent(Class<E> c, Class<? extends Event> event, String ... patterns) {
        Skript.checkAcceptRegistrations();
        events.add(new SkriptEvent.SkriptEventInfo<E>(patterns, c, Skript.array(event)));
    }

    public static <E extends SkriptEvent> void registerEvent(Class<E> c, Class<? extends Event>[] events, String ... patterns) {
        Skript.checkAcceptRegistrations();
        Skript.events.add(new SkriptEvent.SkriptEventInfo<E>(patterns, c, events));
    }

    public static final Collection<SkriptEvent.SkriptEventInfo<?>> getEvents() {
        return events;
    }

    public static <F, T> void registerConverter(Class<F> from, Class<T> to, Converter<F, T> converter) {
        Skript.checkAcceptRegistrations();
        converters.add(new Converter.ConverterInfo<F, T>(from, to, converter));
    }

    private static void createMissingConverters() {
        int i = 0;
        while (i < converters.size()) {
            Converter.ConverterInfo<?, ?> info = converters.get(i);
            int j = 0;
            while (j < converters.size()) {
                Converter.ConverterInfo<?, ?> info2 = converters.get(j);
                if (info2.from.isAssignableFrom(info.to) && !Skript.converterExists(info.from, info2.to)) {
                    converters.add(Skript.createChainedConverter(info, info2));
                } else if (info.from.isAssignableFrom(info2.to) && !Skript.converterExists(info2.from, info.to)) {
                    converters.add(Skript.createChainedConverter(info2, info));
                }
                ++j;
            }
            ++i;
        }
    }

    private static <F, M, T> Converter.ConverterInfo<F, T> createChainedConverter(Converter.ConverterInfo<?, ?> first, Converter.ConverterInfo<?, ?> second) {
        return new Converter.ConverterInfo(first.from, second.to, new ChainedConverter(first.converter, second.converter));
    }

    public static final boolean converterExists(Class<?> from, Class<?> to) {
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!conv.from.isAssignableFrom(from) || !to.isAssignableFrom(conv.to)) continue;
            return true;
        }
        return false;
    }

    public static <F, T> T convert(F o, Class<T> to) {
        Converter<?, T> conv = Skript.getConverter(o.getClass(), to);
        if (conv == null) {
            return null;
        }
        return conv.convert(o);
    }

    public static final <F, T> Converter<? super F, ? extends T> getConverter(Class<F> from, Class<T> to) {
        Converter.ConverterInfo<F, T> ci = Skript.getConverterInfo(from, to);
        if (ci != null) {
            return ci.converter;
        }
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (conv.from.isAssignableFrom(from) && conv.to.isAssignableFrom(to)) {
                return Converter.ConverterUtils.createInstanceofConverter(conv.converter, to);
            }
            if (!from.isAssignableFrom(conv.from) || !to.isAssignableFrom(conv.to)) continue;
            return Converter.ConverterUtils.createInstanceofConverter(conv);
        }
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!from.isAssignableFrom(conv.from) || !conv.to.isAssignableFrom(to)) continue;
            return Converter.ConverterUtils.createDoubleInstanceofConverter(conv, to);
        }
        return null;
    }

    private static final <F, T> Converter.ConverterInfo<? super F, ? extends T> getConverterInfo(Class<F> from, Class<T> to) {
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!conv.from.isAssignableFrom(from) || !to.isAssignableFrom(conv.to)) continue;
            return conv;
        }
        return null;
    }

    public static <T> void registerClass(ClassInfo<T> info) {
        Skript.checkAcceptRegistrations();
        classInfos.add(info);
    }

    public static <T> boolean registerClass(ClassInfo<T> info, boolean addAlways, String ... before) {
        Skript.checkAcceptRegistrations();
        int i = 0;
        while (i < classInfos.size()) {
            if (Utils.contains(before, classInfos.get(i).getCodeName()) != -1) {
                classInfos.add(i, info);
                return true;
            }
            ++i;
        }
        if (addAlways) {
            classInfos.add(info);
        }
        return false;
    }

    private static ClassInfo<?> getClassInfo(String codeName) {
        for (ClassInfo<?> ci : classInfos) {
            if (!ci.getCodeName().equals(codeName)) continue;
            return ci;
        }
        throw new SkriptAPIException("no class info found for " + codeName);
    }

    private static <T> ClassInfo<T> getClassInfo(Class<T> c) {
        for (ClassInfo<?> ci : classInfos) {
            if (ci.getC() != c) continue;
            return ci;
        }
        throw new SkriptAPIException("no class info found for " + c.getName());
    }

    public static Class<?> getClass(String codeName) {
        return Skript.getClassInfo(codeName).getC();
    }

    public static Class<?> getClassFromUserInput(String name) {
        if (name == null) {
            return null;
        }
        for (ClassInfo<?> ci : classInfos) {
            Pattern[] patternArray = ci.getUserInputPatterns();
            int n = patternArray.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern pattern = patternArray[n2];
                if (pattern.matcher(name).matches()) {
                    return ci.getC();
                }
                ++n2;
            }
        }
        return null;
    }

    public static <T> DefaultVariable<?> getDefaultVariable(String name) {
        return Skript.getClassInfo(name).getDefaultVariable();
    }

    public static <T> DefaultVariable<T> getDefaultVariable(Class<T> c) {
        return Skript.getClassInfo(c).getDefaultVariable();
    }

    public static final String getExactClassName(Class<?> c) {
        for (ClassInfo<?> ci : classInfos) {
            if (c != ci.getC()) continue;
            return ci.getName();
        }
        return null;
    }

    private static <T> T parse_simple(String s, Class<T> c) {
        for (ClassInfo<?> info : classInfos) {
            Object t;
            if (info.getParser() == null || !c.isAssignableFrom(info.getC()) || (t = info.getParser().parse(s)) == null) continue;
            return (T)t;
        }
        return null;
    }

    public static <T> T parse(String s, Class<T> c) {
        Object t = Skript.parse_simple(s, c);
        if (t != null) {
            return t;
        }
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            Object o;
            if (!c.isAssignableFrom(conv.to) || (o = Skript.parse_simple(s, conv.from)) == null || (t = Converter.ConverterUtils.convert(conv, o)) == null) continue;
            return t;
        }
        return null;
    }

    public static final <T> Converter<String, ? extends T> getParser(Class<T> to) {
        for (ClassInfo<?> classInfo : classInfos) {
            if (!to.isAssignableFrom(classInfo.getC()) || classInfo.getParser() == null) continue;
            return classInfo.getParser();
        }
        for (Converter.ConverterInfo converterInfo : converters) {
            if (!to.isAssignableFrom(converterInfo.to)) continue;
            for (ClassInfo<?> ci : classInfos) {
                if (!converterInfo.from.isAssignableFrom(ci.getC()) || ci.getParser() == null) continue;
                return ChainedConverter.newInstance(ci.getParser(), ci.getC(), converterInfo.converter);
            }
        }
        return null;
    }

    public static String toString(Object o) {
        return Skript.toString(o, false);
    }

    public static String getDebugMessage(Object o) {
        return Skript.toString(o, true);
    }

    public static final String toString(Object[] os, boolean and) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < os.length) {
            if (i != 0) {
                if (i == os.length - 1) {
                    b.append(and ? " and " : " or ");
                } else {
                    b.append(", ");
                }
            }
            b.append(Skript.toString(os[i]));
            ++i;
        }
        if (b.length() == 0) {
            return "<none>";
        }
        return b.toString();
    }

    private static <T> String toString(T o, boolean debug) {
        if (o == null) {
            return "<none>";
        }
        if (o.getClass().isArray()) {
            if (((Object[])o).length == 0) {
                return "<none>";
            }
            StringBuilder b = new StringBuilder();
            boolean first = true;
            Object[] objectArray = (Object[])o;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object i = objectArray[n2];
                if (!first) {
                    b.append(", ");
                }
                b.append(Skript.toString(i, debug));
                first = false;
                ++n2;
            }
            return "[" + b.toString() + "]";
        }
        for (ClassInfo<?> ci : classInfos) {
            String s;
            if (ci.getParser() == null || !ci.getC().isAssignableFrom(o.getClass())) continue;
            String string = s = debug ? ci.getParser().getDebugMessage(o) : ci.getParser().toString(o);
            if (s == null) continue;
            return s;
        }
        return String.valueOf(o);
    }

    public static <T1, T2> void registerComparator(Class<T1> t1, Class<T2> t2, Comparator<T1, T2> c) {
        Skript.checkAcceptRegistrations();
        if (t1 == Object.class || t2 == Object.class) {
            throw new SkriptAPIException("must not add a comparator for objects");
        }
        comparators.add(new Comparator.ComparatorInfo<T1, T2>(t1, t2, c));
    }

    public static final Collection<Comparator.ComparatorInfo<?, ?>> getComparators() {
        return comparators;
    }

    public static <T1, T2> Comparator.Relation compare(T1 t1, T2 t2) {
        for (Comparator.ComparatorInfo<?, ?> info : comparators) {
            if (info.c1.isInstance(t1) && info.c2.isInstance(t2)) {
                return info.c.compare(t1, t2);
            }
            if (!info.c1.isInstance(t2) || !info.c2.isInstance(t1)) continue;
            return info.c.compare(t2, t1);
        }
        if (t1 != null && t1.getClass().isInstance(t2)) {
            return Comparator.Relation.get(t1.equals(t2));
        }
        if (t2 != null && t2.getClass().isInstance(t1)) {
            return Comparator.Relation.get(t2.equals(t1));
        }
        return null;
    }

    public static <T1, T2> Comparator<T1, T2> getComparator(Class<T1> c1, Class<T2> c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        for (Comparator.ComparatorInfo<?, ?> c : comparators) {
            if (c.c1.isAssignableFrom(c1) && c.c2.isAssignableFrom(c2)) {
                return c.c;
            }
            if (!c.c1.isAssignableFrom(c2) || !c.c2.isAssignableFrom(c1)) continue;
            return new InverseComparator(c.c);
        }
        return null;
    }

    public static <T, E extends Event> void registerEventValue(Class<E> e, Class<T> c, Getter<T, E> g) {
        Skript.checkAcceptRegistrations();
        int i = 0;
        while (i < eventValues.size()) {
            EventValueInfo<?, ?> info = eventValues.get(i);
            if (info.event.isAssignableFrom(e)) {
                eventValues.add(i, new EventValueInfo<E, T>(e, c, g));
                return;
            }
            ++i;
        }
        eventValues.add(new EventValueInfo<E, T>(e, c, g));
    }

    public static <T, E extends Event> T getEventValue(E e, Class<T> c) {
        Getter<T, ?> g = Skript.getEventValueGetter(e.getClass(), c);
        if (g == null) {
            return null;
        }
        return g.convert(e);
    }

    public static final <T, E extends Event> Getter<? extends T, ? super E> getEventValueGetter(Class<E> e, final Class<T> c) {
        for (final EventValueInfo<?, ?> ev : eventValues) {
            if (!ev.event.isAssignableFrom(e) || !c.isAssignableFrom(ev.c)) continue;
            return ev.getter;
        }
        for (final EventValueInfo<?, ?> ev : eventValues) {
            if (!ev.event.isAssignableFrom(e) || !ev.c.isAssignableFrom(c)) continue;
            return new Getter<T, E>(){

                @Override
                public T get(E e) {
                    Object o = ev.getter.get(e);
                    if (c.isInstance(o)) {
                        return o;
                    }
                    return null;
                }
            };
        }
        for (final EventValueInfo<?, ?> ev : eventValues) {
            Getter<T, ?> g;
            if (!ev.event.isAssignableFrom(e) || (g = Skript.getConvertedGetter(ev, c)) == null) continue;
            return g;
        }
        return null;
    }

    private static final <E extends Event, F, T> Getter<? extends T, ? super E> getConvertedGetter(final EventValueInfo<E, F> i, Class<T> to) {
        final Converter c = Skript.getConverter(i.c, to);
        if (c == null) {
            return null;
        }
        return new Getter<T, E>(){

            @Override
            public T get(E e) {
                return c.convert(i.getter.get(e));
            }
        };
    }

    public static <E extends LoopVar<T>, T> void registerLoop(Class<E> c, Class<T> returnType, String ... patterns) {
        Skript.checkAcceptRegistrations();
        loops.add(new LoopVar.LoopInfo<E, T>(c, returnType, patterns));
    }

    public static void registerCommand(SkriptCommand command) {
        commands.add(command);
        commandMap.register("/", (Command)command);
    }

    public static void outdatedError() {
        SkriptLogger.log(Level.SEVERE, "Skript " + instance.getDescription().getVersion() + " is not fully compatible with Bukkit " + Bukkit.getVersion() + ". Please download the newest version of Skript!");
    }

    public static void outdatedError(Exception e) {
        Skript.outdatedError();
        e.printStackTrace();
    }

    public static final boolean logNormal() {
        return SkriptLogger.log(Verbosity.NORMAL);
    }

    public static final boolean logHigh() {
        return SkriptLogger.log(Verbosity.HIGH);
    }

    public static final boolean logVeryHigh() {
        return SkriptLogger.log(Verbosity.VERY_HIGH);
    }

    public static final boolean debug() {
        return SkriptLogger.debug;
    }

    public static final boolean log(Verbosity minVerb) {
        return SkriptLogger.log(minVerb);
    }

    public static void config(String info) {
        SkriptLogger.log(Level.CONFIG, info);
    }

    public static void info(String info) {
        SkriptLogger.log(Level.INFO, info);
    }

    public static final ErrorSession startErrorSession() {
        if (errorSession != null) {
            errorSessionStack.addFirst(errorSession);
        }
        errorSession = new ErrorSession();
        return errorSession;
    }

    public static final void stopErrorSession() {
        errorSession = errorSessionStack.poll();
    }

    public static final ErrorSession getCurrentErrorSession() {
        return errorSession;
    }

    public static void warning(String warning) {
        if (errorSession != null) {
            errorSession.warning(warning);
        } else {
            SkriptLogger.log(Level.WARNING, warning);
        }
    }

    public static void error(String error) {
        if (errorSession != null) {
            errorSession.error(error);
        } else {
            SkriptLogger.log(Level.SEVERE, error);
        }
    }

    public static final RuntimeException exception(String ... info) {
        return Skript.exception(null, info);
    }

    public static final RuntimeException exception(Exception cause, String ... info) {
        SkriptLogger.setPrefix(EXCEPTION_PREFIX);
        SkriptLogger.logDirect(Level.SEVERE, "");
        SkriptLogger.logDirect(Level.SEVERE, "Severe Error:");
        Object[] objectArray = info;
        int n = info.length;
        int n2 = 0;
        while (n2 < n) {
            String i = objectArray[n2];
            SkriptLogger.logDirect(Level.SEVERE, i);
            ++n2;
        }
        SkriptLogger.logDirect(Level.SEVERE, "");
        SkriptLogger.logDirect(Level.SEVERE, "If you're developing an add-on for Skript this likely means you have done something wrong.");
        SkriptLogger.logDirect(Level.SEVERE, "If you're a server admin, please go to http://dev.bukkit.org/server-mods/skript/tickets/");
        SkriptLogger.logDirect(Level.SEVERE, "and create a new ticket with a meaningful title, copy & paste this whole error into it,");
        SkriptLogger.logDirect(Level.SEVERE, "and please describe what you did before it happened and/or what you think caused the error.");
        SkriptLogger.logDirect(Level.SEVERE, "If you feel like it's a trigger that's causing the error please post the trigger as well.");
        SkriptLogger.logDirect(Level.SEVERE, "By following this guide fixing the error should be easy and done fast.");
        SkriptLogger.logDirect(Level.SEVERE, "");
        SkriptLogger.logDirect(Level.SEVERE, "Stacktrace:");
        if (cause == null) {
            SkriptLogger.logDirect(Level.SEVERE, "  warning: no exception given, dumping current stack trace instead");
            cause = new Exception();
        }
        SkriptLogger.logDirect(Level.SEVERE, cause.toString());
        objectArray = cause.getStackTrace();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            SkriptLogger.logDirect(Level.SEVERE, "    at " + ((StackTraceElement)e).toString());
            ++n2;
        }
        SkriptLogger.logDirect(Level.SEVERE, "");
        SkriptLogger.logDirect(Level.SEVERE, "Version Information:");
        SkriptLogger.logDirect(Level.SEVERE, "  Skript version: " + Skript.getInstance().getDescription().getVersion());
        SkriptLogger.logDirect(Level.SEVERE, "  Bukkit version: " + Bukkit.getBukkitVersion());
        SkriptLogger.logDirect(Level.SEVERE, "  Java version: " + System.getProperty("java.version"));
        SkriptLogger.logDirect(Level.SEVERE, "");
        SkriptLogger.logDirect(Level.SEVERE, "Running CraftBukkit: " + (Bukkit.getServer() instanceof CraftServer));
        SkriptLogger.logDirect(Level.SEVERE, "");
        SkriptLogger.logDirect(Level.SEVERE, "Current node: " + SkriptLogger.getNode());
        SkriptLogger.logDirect(Level.SEVERE, "");
        SkriptLogger.logDirect(Level.SEVERE, "End of Error.");
        SkriptLogger.logDirect(Level.SEVERE, "");
        SkriptLogger.resetPrefix();
        RuntimeException r = new RuntimeException();
        r.setStackTrace(new StackTraceElement[0]);
        return r;
    }

    private static final void parseMainConfig() {
        ErrorSession session = Skript.startErrorSession();
        final ArrayList aliasNodes = new ArrayList();
        new SectionValidator().addNode("verbosity", new EnumEntryValidator<Verbosity>(Verbosity.class, new Setter<Verbosity>(){

            @Override
            public void set(Verbosity v) {
                SkriptLogger.setVerbosity(v);
            }
        }), false).addNode("plugin priority", new EnumEntryValidator<EventPriority>(EventPriority.class, new Setter<EventPriority>(){

            @Override
            public void set(EventPriority p) {
                priority = p;
            }
        }, "lowest, low, normal, high, highest"), false).addEntry("aliases", new Setter<String>(){

            @Override
            public void set(String s) {
                String[] stringArray = s.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String n3 = stringArray[n2];
                    aliasNodes.add(n3.trim());
                    ++n2;
                }
            }
        }, false).addEntry("keep configs loaded", Boolean.class, new Setter<Boolean>(){

            @Override
            public void set(Boolean b) {
                keepConfigsLoaded = b;
            }
        }, false).addEntry("enable effect commands", Boolean.class, new Setter<Boolean>(){

            @Override
            public void set(Boolean b) {
                enableEffectCommands = b;
            }
        }, false).setAllowUndefinedSections(true).validate(mainConfig.getMainNode(), true);
        for (Node node : mainConfig.getMainNode()) {
            if (!(node instanceof SectionNode) || aliasNodes.contains(node.getName())) continue;
            Skript.error("Invalid section '" + node.getName() + "'. If this is an alias section add it to 'aliases' so it will be loaded.");
        }
        HashMap<String, HashMap<String, ItemType>> variations = new HashMap<String, HashMap<String, ItemType>>();
        int num = 0;
        for (String an : aliasNodes) {
            Node node = mainConfig.getMainNode().get(an);
            SkriptLogger.setNode(node);
            if (node == null) {
                Skript.error("alias section '" + an + "' not found!");
                continue;
            }
            if (!(node instanceof SectionNode)) {
                Skript.error("aliases have to be in sections, but '" + an + "' is not a section!");
                continue;
            }
            int i = 0;
            for (Node n : (SectionNode)node) {
                if (n instanceof EntryNode) {
                    i += Aliases.addAliases(((EntryNode)n).getKey(), ((EntryNode)n).getValue(), variations);
                    continue;
                }
                if (!(n instanceof SectionNode)) continue;
                if (!n.getName().startsWith("{") || !n.getName().endsWith("}")) {
                    Skript.error("unexpected non-variation section");
                    continue;
                }
                HashMap<String, ItemType> vs = new HashMap<String, ItemType>();
                for (Node a : (SectionNode)n) {
                    if (a instanceof SectionNode) {
                        Skript.error("unexpected section");
                        continue;
                    }
                    ItemType t = Aliases.parseAlias(((EntryNode)a).getValue());
                    if (t != null) {
                        vs.put(((EntryNode)a).getKey(), t);
                        continue;
                    }
                    session.printErrors("'" + ((EntryNode)a).getValue() + "' is invalid");
                }
                variations.put(n.getName().substring(1, n.getName().length() - 1), vs);
            }
            if (Skript.logHigh()) {
                Skript.info("loaded " + i + " alias" + (i == 1 ? "" : "es") + " from " + node.getName());
            }
            num += i;
        }
        SkriptLogger.setNode(null);
        if (!keepConfigsLoaded) {
            mainConfig = null;
        }
        if (Skript.log(Verbosity.NORMAL)) {
            Skript.info("loaded a total of " + num + " aliases");
        }
        Aliases.addMissingMaterialNames();
        if (enableEffectCommands) {
            if (commandMap == null) {
                Skript.error("you have to use CraftBukkit to use commands");
            } else {
                Bukkit.getPluginManager().registerEvents(new Listener(){

                    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
                    public void onPlayerCommand(PlayerCommandPreprocessEvent e) {
                        if (Skript.handleEffectCommand((CommandSender)e.getPlayer(), e.getMessage().substring(1))) {
                            e.setCancelled(true);
                        }
                    }

                    @EventHandler(priority=EventPriority.HIGHEST)
                    public void onServerCommand(ServerCommandEvent e) {
                        if (Skript.handleEffectCommand(e.getSender(), e.getCommand())) {
                            e.setCommand("");
                        }
                    }
                }, (Plugin)instance);
            }
        }
        Skript.stopErrorSession();
    }

    private static boolean handleEffectCommand(CommandSender sender, String command) {
        if (!sender.hasPermission("skript.effectcommands")) {
            return false;
        }
        String x = command.split(" ", 2)[0];
        if (commandMap.getCommand(x) != null) {
            return false;
        }
        ErrorSession session = Skript.startErrorSession();
        Effect e = Effect.parse(command);
        Skript.stopErrorSession();
        if (e != null) {
            String[] c = command.split(" ");
            sender.sendMessage(ChatColor.GRAY + ChatColor.stripColor((String)command));
            e.run(new CommandEvent(sender, c[0], c.length > 1 ? Arrays.copyOfRange(c, 1, c.length - 1) : new String[]{}));
            return true;
        }
        if (session.hasErrors()) {
            sender.sendMessage(ChatColor.GRAY + ChatColor.stripColor((String)command));
            session.printErrors(sender);
            return true;
        }
        Skript.exception("Effect was neither parsed nor was any error logged!", "input: " + command, "sent by: " + sender.getName() + (sender instanceof ConsoleCommandSender ? "" : " (the user was told to inform an admin)"));
        if (!(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage(ChatColor.RED + "[Skript] Unexpected error! Please tell an admin to check the server log.");
        }
        return false;
    }

    private void loadMainConfig() {
        try {
            File config = new File(this.getDataFolder(), "config.cfg");
            if (!config.exists()) {
                Skript.error("Config file 'config.cfg' does not exist!");
                return;
            }
            if (!config.canRead()) {
                Skript.error("Config file 'config.cfg' cannot be read!");
                return;
            }
            mainConfig = new Config(config, false, "=");
            Skript.parseMainConfig();
        }
        catch (Exception e) {
            Skript.exception(e, "error loading config");
        }
    }

    private static void loadTriggerFiles() {
        boolean successful = true;
        int numFiles = 0;
        ErrorSession session = Skript.startErrorSession();
        try {
            File includes = new File(instance.getDataFolder(), TRIGGERFILEFOLDER + File.separatorChar);
            File[] fileArray = includes.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".cfg") && !name.startsWith("-");
                }
            });
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                Config c = new Config(f, true, ":");
                if (keepConfigsLoaded) {
                    configs.add(c);
                }
                TriggerFileLoader.load(c);
                ++numFiles;
                ++n2;
            }
        }
        catch (Exception e) {
            SkriptLogger.setNode(null);
            Skript.exception(e, "could not load trigger files");
            successful = false;
        }
        if (successful && Skript.log(Verbosity.NORMAL)) {
            Skript.info("loaded " + numFiles + " trigger file" + (numFiles == 1 ? "" : "s") + " with a total of " + TriggerFileLoader.loadedTriggers + " trigger" + (TriggerFileLoader.loadedTriggers == 1 ? "" : "s") + " and " + TriggerFileLoader.loadedCommands + " command" + (TriggerFileLoader.loadedCommands == 1 ? "" : "s"));
        }
        for (Map.Entry<Class<? extends Event>, List<Trigger>> e : SkriptEventHandler.triggers.entrySet()) {
            Bukkit.getServer().getPluginManager().registerEvent(e.getKey(), new Listener(){}, priority, SkriptEventHandler.ee, (Plugin)instance);
            if (!Skript.log(Verbosity.DEBUG)) continue;
            Skript.config("registered Event " + e.getKey().getSimpleName());
        }
    }

    public static String getExpressionName(Class<? extends Expression> c) {
        if (Condition.class.isAssignableFrom(c)) {
            return "condition";
        }
        if (Effect.class.isAssignableFrom(c)) {
            return "effect";
        }
        if (LoopVar.class.isAssignableFrom(c)) {
            return "loop";
        }
        if (Variable.class.isAssignableFrom(c)) {
            return "variable";
        }
        throw new IllegalArgumentException(c.getName());
    }

    static /* synthetic */ EventPriority access$2() {
        return priority;
    }

    static final class EventValueInfo<E extends Event, T> {
        Class<E> event;
        Class<T> c;
        Getter<T, E> getter;

        public EventValueInfo(Class<E> event, Class<T> c, Getter<T, E> getter) {
            Validate.notNull(event, c, getter);
            this.event = event;
            this.c = c;
            this.getter = getter;
        }
    }
}

