/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.PlayerCommand;
import ch.njol.skript.util.Utils;
import java.util.HashMap;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class CommandHandler {
    private static final HashMap<String, PlayerCommand> playerCommandDatas = new HashMap();
    static final int linesPerPage = 8;
    private static final String[] commandHelp = new String[]{" -- actions --", " a command should start with one of these", "s[elect]: selects an item. same as --s", "a[dd]/n[ew]: creates a new node in the selected node", "r[ename]: renames the selected node", "v[alue]: changes the value of the node", "m[ove]: moves the selected node, /s m for more info", "d[elete]: deletes the selected node", "l[ist]: prints the subnodes of the selected node", "e[nable]/d[isable]: en/disable the selected config file", "save: saves the config file. same as --save", "", "-- flags --", " these can be added to the command after the action and will be processed beforehand", "--s[elect]: selects an item", "--c[onfig]: switches to a different config file and selects it's main node", "--a[ccept]: accepts all questions of the next option, or the main action if this is the last flag", "--v, --vv etc.: sets the verbosity; the move vs the higher", "--save: saves the config file after the operation"};

    public static boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("skript.config")) {
            sender.sendMessage("You do not have permission to use this command");
            return true;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("h") || args[0].equalsIgnoreCase("help")) {
            int page = 1;
            try {
                page = Math.min((int)Math.ceil(commandHelp.length / 8), Math.max(1, Integer.parseInt(args[1])));
            }
            catch (Exception exception) {
                // empty catch block
            }
            sender.sendMessage("&8== Skript help (page " + page + " of " + Math.ceil(commandHelp.length / 8) + ")");
            int i = (page - 1) * 8;
            while (i < page * 8) {
                sender.sendMessage(commandHelp[i]);
                ++i;
            }
        }
        sender.sendMessage("&7" + label + Utils.join(args, " "));
        PlayerCommand data = (PlayerCommand)playerCommandDatas.get(sender.getName());
        if (data == null) {
            data = new PlayerCommand();
            playerCommandDatas.put(sender.getName(), data);
        }
        data.onCommand(sender, command, label, args);
        return true;
    }
}

