package ch.njol.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RegexUtils {
	
	/**
	 * performs regex replacing using a callback.
	 * 
	 * @param string the String in which should be searched & replaced
	 * @param regex the Regex to match
	 * @param callback the callback will be run for every match of regex in string, and should return the replacement string for the given match. It's argument is an array of
	 *            strings, where the first element is the whole matched string, and all subsequent elements are the matched groups.
	 * @return
	 */
	public final static String replaceAll(final String string, final String regex, final Callback<String, Matcher> callback) {
		final Matcher m = Pattern.compile(regex).matcher(string);
		final StringBuffer sb = new StringBuffer();
		while (m.find()) {
			m.appendReplacement(sb, callback.run(m));
		}
		m.appendTail(sb);
		return sb.toString();
	}
}
