

package ch.njol.util;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class Pair<T1, T2> {
	public T1 first;
	public T2 second;
	
	public Pair() {
		first = null;
		second = null;
	}
	
	public Pair(final T1 first, final T2 second) {
		this.first = first;
		this.second = second;
	}
	
	/**
	 * @return "first,second"
	 */
	@Override
	public String toString() {
		return "" + first + "," + second;
	}
	
	@Override
	public boolean equals(final Object other) {
		if (other == this)
			return true;
		if (!(other instanceof Pair))
			return false;
		if (((Pair<?, ?>) other).hashCode() != this.hashCode())
			return false;
		return ((Pair<?, ?>) other).first.equals(first) && ((Pair<?, ?>) other).second.equals(second);
	}
	
	@Override
	public int hashCode() {
		return first.hashCode() ^ Integer.MAX_VALUE ^ second.hashCode();
	}
}
