
package ch.njol.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

/**
 * A simple iterator to iterate over an array.
 * 
 * @author Peter Gttinger
 */
public class ArrayIterator<T> implements Iterator<T> {
	
	private final T[] array;
	private int i = 0;
	
	public ArrayIterator(final T[] array) {
		this.array = array;
	}
	
	@Override
	public boolean hasNext() {
		return i < array.length;
	}
	
	@Override
	public T next() {
		if (i >= array.length)
			throw new NoSuchElementException();
		return array[i++];
	}
	
	/**
	 * not supported by arrays.
	 * 
	 * @throws UnsupportedOperationException always
	 */
	@Override
	public void remove() {
		throw new UnsupportedOperationException();
	}
	
}
