/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.variables.base;

import org.bukkit.event.Event;

import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public abstract class VarVariable extends Variable<Object> {
	
	protected Variable<?> var;
	
	@Override
	public <R> Variable<? extends R> getConvertedVar(final Class<R> to) {
		return var.getConvertedVar(to);
	}
	
	@Override
	protected Object[] getAll(final Event e) {
		return var.get(e);
	}
	
	@Override
	public void setAnd(final boolean and) {
		super.setAnd(and);
		var.setAnd(and);
	}
	
	@Override
	public Class<?> getReturnType() {
		return var.getReturnType();
	}
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		return var.acceptChange(mode);
	}
	
	@Override
	public void change(final Event e, final Variable<?> delta, final ChangeMode mode) {
		var.change(e, delta, mode);
	}
	
	@Override
	public String toString() {
		return var.toString();
	}
	
}
