/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.World;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.Getter;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timespan;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class VarTime extends Variable<Time> {
	
	static {
		Skript.addVariable(VarTime.class, Time.class, "time( (in|of) %world%)?");
	}
	
	private Variable<World> worlds = null;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		worlds = (Variable<World>) vars.get(0);
	}
	
	@Override
	protected Time[] getAll(final Event e) {
		return get(e, worlds, new Getter<Time, World>() {
			@Override
			public Time get(final World w) {
				return new Time((int) w.getTime());
			}
		}, false);
	}
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		switch (mode) {
			case ADD:
			case REMOVE:
				return Timespan.class;
			case SET:
				return Time.class;
			default:
				return null;
		}
	}
	
	@SuppressWarnings("incomplete-switch")
	@Override
	public void change(final Event e, final Variable<?> delta, final ChangeMode mode) {
		int x = 1;
		switch (mode) {
			case SET:
				final Time time = (Time) delta.getFirst(e);
				for (final World w : worlds.get(e, false)) {
					w.setTime(time.getTicks());
				}
			break;
			case REMOVE:
				x = -1;
				//$FALL-THROUGH$
			case ADD:
				final Timespan ts = (Timespan) delta.getFirst(e);
				for (final World w : worlds.get(e, false)) {
					w.setTime((long) (w.getTime() + x * ts.getTicks()));
				}
			break;
		}
	}
	
	@Override
	public Class<Time> getReturnType() {
		return Time.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return "time in " + worlds.getDebugMessage(e);
		return Skript.toString(getAll(e));
	}
	
}
