/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.InitException;
import ch.njol.skript.api.Variable;
import ch.njol.skript.data.DefaultChangers;

/**
 * @author Peter Gttinger
 * 
 */
public class VarPlayer extends Variable<Player> {
	
	static {
		Skript.addVariable(VarPlayer.class, Player.class, "player", "me", "\"([a-zA-Z0-9_]+?)\"");
	}
	
	private OfflinePlayer player;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws InitException {
		if (matchedPattern == 2) {
			player = Bukkit.getOfflinePlayer(matcher.group(1));
		}
	}
	
	@Override
	protected Player[] getAll(final Event e) {
		if (player == null)
			return new Player[] {Skript.getEventValue(e, Player.class)};
		return new Player[] {player.getPlayer()};
	}
	
	@Override
	public Class<Player> getReturnType() {
		return Player.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return player == null ? "player" : '"' + player.getName() + '"';
		return Skript.toString(getAll(e)[0]);
	}
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		return DefaultChangers.inventoryChanger.acceptChange(mode);
	}
	
	@Override
	public void change(final Event e, final Variable<?> delta, final ChangeMode mode) {
		final Player[] players = get(e);
		final Inventory[] invis = new Inventory[players.length];
		for (int i = 0; i < players.length; i++)
			invis[i] = players[i] == null ? null : players[i].getInventory();
		DefaultChangers.inventoryChanger.change(invis, delta.get(e), mode);
	}
	
	@Override
	public String toString() {
		if (player == null)
			return "the player";
		return player.getName();
	}
}
