/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.InitException;
import ch.njol.skript.api.ParseException;
import ch.njol.skript.api.Variable;
import ch.njol.skript.data.DefaultChangers;
import ch.njol.skript.util.Offset;

/**
 * @author Peter Gttinger
 * 
 */
public class VarOffset extends Variable<Object> {
	
	static {
		Skript.addVariable(VarOffset.class, Object.class,
				"blocks? %offset%( %block%)?",
				"%offset% %location%");
	}
	
	private Variable<Offset> offsets;
	private Variable<Block> blocks;
	private Variable<Location> locations;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws InitException, ParseException {
		offsets = (Variable<Offset>) vars.get(0);
		if (matchedPattern == 0)
			blocks = (Variable<Block>) vars.get(1);
		else
			locations = (Variable<Location>) vars.get(1);
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (blocks != null) {
			return "block " + offsets.getDebugMessage(e) + " " + blocks.getDebugMessage(e);
		} else {
			return offsets.getDebugMessage(e) + " " + locations.getDebugMessage(e);
		}
	}
	
	@Override
	protected Object[] getAll(final Event e) {
		if (blocks != null) {
			return Offset.setOff(offsets.get(e), blocks.get(e));
		} else {
			return Offset.setOff(offsets.get(e), locations.get(e));
		}
	}
	
	@Override
	public Class<?> getReturnType() {
		if (blocks == null)
			return Location.class;
		return Block.class;
	}
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		if (blocks == null)
			return null;
		return DefaultChangers.blockChanger.acceptChange(mode);
	}
	
	@Override
	public void change(final Event e, final Variable<?> delta, final ChangeMode mode) {
		DefaultChangers.blockChanger.change((Block[]) get(e), delta.get(e), mode);
	}
	
}
