/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.TriggerFileLoader;
import ch.njol.skript.api.LoopVar;
import ch.njol.skript.api.ParseException;
import ch.njol.skript.api.Variable;
import ch.njol.skript.variables.base.VarVariable;
import ch.njol.util.Pair;

/**
 * used to access a loop's current value.
 * 
 * @author Peter Gttinger
 * 
 */
public class VarLoopValue extends VarVariable {
	
	static {
		Skript.addVariable(VarLoopValue.class, Object.class, "loop-(\\S+)");
	}
	
	private String name;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws ParseException {
		name = matcher.group();
		String s = matcher.group(1);
		int i = 1;
		final Matcher m = Pattern.compile("^(.+)-(\\d+)$").matcher(matcher.group(1));
		if (m.matches()) {
			s = m.group(1);
			i = Integer.parseInt(m.group(2));
		}
		for (final Pair<String, LoopVar<?>> p : TriggerFileLoader.currentLoops) {
			if (p.first.equalsIgnoreCase(s)) {
				if (i > 1) {
					i--;
					continue;
				}
				var = p.second;
				return;
			}
		}
		throw new ParseException("There's no loop that matches " + matcher.group());
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return name;
		return var.getDebugMessage(e);
	}
	
}
