/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.ParseException;
import ch.njol.skript.api.Variable;
import ch.njol.skript.variables.base.VarVariable;

/**
 * @author Peter Gttinger
 * 
 *         provided for convenience: one can write event-world to distinguish between the world named 'world', the event's world, and the loop's world for example.
 * 
 */
public class VarEventVariable extends VarVariable {
	
	static {
		Skript.addVariable(VarEventVariable.class, Object.class, "event-(\\S+)");
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return var.getDebugMessage(e);
	}
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws ParseException {
		var = Variable.parseNoLiteral(matcher.group(1), Skript.getVariables().iterator());
		if (var == null)
			throw new ParseException("'" + matcher.group() + "' is invalid");
	}
	
}
