/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.EntityType;
import ch.njol.util.Checker;

/**
 * @author Peter Gttinger
 * 
 */
public class VarAttacked extends Variable<Entity> {
	
	static {
		Skript.addVariable(VarAttacked.class, Entity.class, "(attacked|damaged|victim)( %entitytype%)?");
	}
	
	Variable<EntityType> types;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		types = (Variable<EntityType>) vars.get(0);
	}
	
	@Override
	protected Entity[] getAll(final Event e) {
		if (e instanceof EntityDamageEvent) {
			final Entity entity = ((EntityDamageEvent) e).getEntity();
			if (types.check(e, new Checker<EntityType>() {
				@Override
				public boolean check(final EntityType t) {
					return t.isInstance(entity);
				}
			}, false, false)) {
				return new Entity[] {entity};
			}
		} else if (e instanceof VehicleDamageEvent) {
			return new Entity[] {((VehicleDamageEvent) e).getVehicle()};
		} else if (e instanceof VehicleDestroyEvent) {
			return new Entity[] {((VehicleDestroyEvent) e).getVehicle()};
		}
		return null;
	}
	
	@Override
	public Class<? extends Entity> getReturnType() {
		return Entity.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return "attacked " + types.getDebugMessage(e);
		return Skript.toString(getFirst(e), true);
	}
	
}
