/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;

import ch.njol.skript.CommandEvent;
import ch.njol.skript.Skript;
import ch.njol.skript.api.InitException;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.Utils;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class VarArgument extends Variable<String> {
	
	static {
		Skript.addVariable(VarArgument.class, String.class, "arg(ument)?[- ](\\d+)", "arg(ument)?s");
	}
	
	private int arg = -1;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		if (matchedPattern == 0)
			arg = Integer.parseInt(matcher.group(2));
	}
	
	@Override
	protected String[] getAll(final Event e) {
		if (!(e instanceof PlayerCommandPreprocessEvent || e instanceof ServerCommandEvent || e instanceof CommandEvent))
			return null;
		String command;
		if (e instanceof PlayerCommandPreprocessEvent)
			command = ((PlayerCommandPreprocessEvent) e).getMessage().substring(1);
		else if (e instanceof ServerCommandEvent)
			command = ((ServerCommandEvent) e).getCommand().substring(1);
		else
			command = Utils.join(((CommandEvent) e).getArgs(), " ");
		if (arg == -1)
			return new String[] {command};
		return new String[] {command.split(" ")[arg]};
	}
	
	@Override
	public <R> Variable<R> getConvertedVar(final Class<R> to) {
		final VarArgument v = this;
		return new Variable<R>() {
			@Override
			protected R[] getAll(final Event e) {
				return Expressions.parseData(Utils.join(v.getAll(e), " "), to);
			}
			
			@Override
			public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws InitException {}
			
			@Override
			public String getDebugMessage(final Event e) {
				if (e == null)
					return (arg == -1 ? "arguments" : "argument-" + arg) + "->" + to.getName();
				return Skript.toString(getAll(e));
			}
			
			@Override
			public Class<? extends R> getReturnType() {
				return to;
			}
		};
	}
	
	@Override
	public Class<? extends String> getReturnType() {
		return String.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return arg == -1 ? "arguments" : "argument-" + arg;
		return Skript.toString(get(e));
	}
	
}
