/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.util;

import java.util.Iterator;

import org.bukkit.Location;
import org.bukkit.block.Block;

public class BlockSphereIterator implements Iterator<Block> {
	
	final Location center;
	final float radius;
	private int x, y, z;
	private Block current, next;
	
	public BlockSphereIterator(final Location center, final float radius) {
		this.center = center;
		this.radius = radius;
		x = (int) Math.round(center.getX() - radius);
		y = (int) Math.round(center.getY() - radius);
		z = (int) Math.round(center.getZ() - radius);
	}
	
	private final double distSq() {
		return (center.getX() - x) * (center.getX() - x) + (center.getY() - y) * (center.getY() - y) + (center.getZ() - z) * (center.getZ() - z);
	}
	
	@Override
	public boolean hasNext() {
		if (next == null)
			next();
		return next != null;
	}
	
	@Override
	public Block next() {
		next = null;
		for (; next != null && x < Math.round(center.getX() + radius); x++) {
			for (; next != null && y < Math.round(center.getY() + radius); y++) {
				for (; next != null && z < Math.round(center.getZ() + radius); z++) {
					if (distSq() > radius * radius)
						continue;
					next = center.getWorld().getBlockAt(x, y, z);
				}
			}
		}
		if (next != null)
			current = next;
		return next;
	}
	
	@Override
	public void remove() {
		throw new UnsupportedOperationException();
	}
	
	public Block current() {
		return current;
	}
}
