/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.loops;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.LoopVar;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.ItemType;
import ch.njol.util.CheckedIterator;
import ch.njol.util.Checker;

/**
 * @author Peter Gttinger
 * 
 */
public class LoopVarItem extends LoopVar<ItemStack> {
	
	static {
		Skript.addLoop(LoopVarItem.class, ItemStack.class, "item", "item(s| ?types)", "items of types? %itemtype%");
		Skript.addLoop(LoopVarItem.class, ItemStack.class, "block", "block(s| ?types)", "blocks of types? %itemtype%");
	}
	
	private Variable<ItemType> types = null;
	private boolean blocks = false;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		if (vars.size() > 0)
			types = (Variable<ItemType>) vars.get(0);
		blocks = matcher.group().startsWith("block");
	}
	
	@Override
	protected Iterator<ItemStack> iterator(final Event e) {
		Iterator<ItemStack> iter;
		if (types == null) {
			iter = new Iterator<ItemStack>() {
				
				private final Iterator<Material> iter = Arrays.asList(Material.values()).iterator();
				
				@Override
				public boolean hasNext() {
					return iter.hasNext();
				}
				
				@Override
				public ItemStack next() {
					return new ItemStack(iter.next());
				}
				
				@Override
				public void remove() {}
				
			};
		} else {
			iter = new Iterator<ItemStack>() {
				
				private final Iterator<ItemType> iter = types.get(e, false).iterator();
				Iterator<ItemStack> current;
				
				@Override
				public boolean hasNext() {
					return iter.hasNext() || current.hasNext();
				}
				
				@Override
				public ItemStack next() {
					if (current == null || !current.hasNext()) {
						current = iter.next().getAll().iterator();
					}
					return current.next();
				}
				
				@Override
				public void remove() {}
				
			};
		}
		
		if (!blocks)
			return iter;
		
		return new CheckedIterator<ItemStack>(iter, new Checker<ItemStack>() {
			@Override
			public boolean check(final ItemStack is) {
				return is.getTypeId() <= Skript.MAXBLOCKID;
			}
		});
	}
	
	@Override
	public Class<? extends ItemStack> getReturnType() {
		return ItemStack.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return (blocks ? "blocks" : "items") + " of type " + types.getDebugMessage(e);
	}
	
}
